/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.EventObject;
import java.util.Iterator;
import org.apache.commons.lang.SerializationUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleException;
import org.mule.MuleManager;
import org.mule.config.i18n.Message;
import org.mule.impl.MuleSession;
import org.mule.impl.ResponseOutputStream;
import org.mule.impl.endpoint.MuleEndpoint;
import org.mule.impl.security.MuleCredentials;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.UMOSession;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.security.UMOCredentials;
import org.mule.umo.transformer.TransformerException;
import org.mule.umo.transformer.UMOTransformer;
import org.mule.util.UUID;

public class MuleEvent
extends EventObject
implements UMOEvent {
    private static final long serialVersionUID = 7568207722883309919L;
    protected transient Log logger = LogFactory.getLog(this.getClass());
    private transient UMOImmutableEndpoint endpoint = null;
    private String id = null;
    private UMOMessage message = null;
    private transient UMOSession session;
    private boolean stopFurtherProcessing = false;
    private boolean synchronous = false;
    private int timeout = Integer.MIN_VALUE;
    private transient ResponseOutputStream outputStream = null;
    private transient Object transformedMessage = null;
    private UMOCredentials credentials = null;
    protected String[] ignorredPropertyOverides = new String[]{"method"};

    public MuleEvent(UMOMessage message, UMOImmutableEndpoint endpoint, UMOComponent component, UMOEvent previousEvent) {
        super(message.getPayload());
        this.message = message;
        this.id = this.generateEventId();
        this.session = previousEvent.getSession();
        ((MuleSession)this.session).setComponent(component);
        this.endpoint = endpoint;
        this.synchronous = previousEvent.isSynchronous();
        this.timeout = previousEvent.getTimeout();
        this.outputStream = (ResponseOutputStream)previousEvent.getOutputStream();
        this.fillProperties(previousEvent);
    }

    public MuleEvent(UMOMessage message, UMOImmutableEndpoint endpoint, UMOSession session, boolean synchronous) {
        this(message, endpoint, session, synchronous, null);
    }

    public MuleEvent(UMOMessage message, UMOImmutableEndpoint endpoint, UMOSession session, boolean synchronous, ResponseOutputStream outputStream) {
        super(message.getPayload());
        this.message = message;
        this.endpoint = endpoint;
        this.session = session;
        this.id = this.generateEventId();
        this.synchronous = synchronous;
        this.outputStream = outputStream;
        this.fillProperties(null);
    }

    public MuleEvent(UMOMessage message, UMOImmutableEndpoint endpoint, UMOSession session, String eventId, boolean synchronous) {
        super(message.getPayload());
        this.message = message;
        this.endpoint = endpoint;
        this.session = session;
        this.id = eventId;
        this.synchronous = synchronous;
        this.fillProperties(null);
    }

    public MuleEvent(UMOMessage message, UMOEvent rewriteEvent) {
        super(message.getPayload());
        this.message = message;
        this.id = rewriteEvent.getId();
        this.session = rewriteEvent.getSession();
        ((MuleSession)this.session).setComponent(rewriteEvent.getComponent());
        this.endpoint = rewriteEvent.getEndpoint();
        this.synchronous = rewriteEvent.isSynchronous();
        this.timeout = rewriteEvent.getTimeout();
        this.outputStream = (ResponseOutputStream)rewriteEvent.getOutputStream();
        if (rewriteEvent instanceof MuleEvent) {
            this.transformedMessage = ((MuleEvent)rewriteEvent).getCachedMessage();
        }
        this.fillProperties(rewriteEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fillProperties(UMOEvent previousEvent) {
        if (previousEvent != null) {
            UMOMessage msg;
            UMOMessage uMOMessage = msg = previousEvent.getMessage();
            synchronized (uMOMessage) {
                Iterator iterator = msg.getPropertyNames().iterator();
                while (iterator.hasNext()) {
                    Object currentValue;
                    Object value;
                    String prop = (String)iterator.next();
                    if (!this.ignoreProperty(prop, value = msg.getProperty(prop))) {
                        this.message.setProperty(prop, value);
                    }
                    if (!this.logger.isDebugEnabled() || value.equals(currentValue = this.message.getProperty(prop))) continue;
                    this.logger.warn((Object)("Property on the current message " + prop + "=" + currentValue + " overrides property on the previous event: " + prop + "=" + value));
                }
            }
        }
        if (this.endpoint != null && this.endpoint.getProperties() != null) {
            Iterator iterator = this.endpoint.getProperties().keySet().iterator();
            while (iterator.hasNext()) {
                Object currentValue;
                Object value;
                String prop = (String)iterator.next();
                if (!this.ignoreProperty(prop, value = this.endpoint.getProperties().get(prop))) {
                    this.message.setProperty(prop, value);
                }
                if (!this.logger.isDebugEnabled() || value.equals(currentValue = this.message.getProperty(prop))) continue;
                this.logger.warn((Object)("Property on the current message " + prop + "=" + currentValue + " overrides property on the endpoint: " + prop + "=" + value));
            }
        }
        this.setCredentials();
    }

    protected boolean ignoreProperty(String key, Object value) {
        if (key == null || value == null) {
            return true;
        }
        if (key.startsWith("MULE_") && this.message.getProperty(key) != null) {
            return true;
        }
        for (int i = 0; i < this.ignorredPropertyOverides.length; ++i) {
            if (!key.equals(this.ignorredPropertyOverides[i])) continue;
            return false;
        }
        return this.message.getProperty(key) != null;
    }

    protected void setCredentials() {
        if (this.endpoint.getEndpointURI().getUserInfo() != null) {
            String userName = this.endpoint.getEndpointURI().getUsername();
            String password = this.endpoint.getEndpointURI().getPassword();
            if (password != null && userName != null) {
                this.credentials = new MuleCredentials(userName, password.toCharArray());
            }
        }
    }

    public UMOCredentials getCredentials() {
        return this.credentials;
    }

    Object getCachedMessage() {
        return this.transformedMessage;
    }

    public UMOMessage getMessage() {
        return this.message;
    }

    public byte[] getMessageAsBytes() throws MuleException {
        try {
            return this.message.getPayloadAsBytes();
        }
        catch (Exception e) {
            throw new MuleException(new Message(69, this.message.getPayload().getClass().getName()), (Throwable)e);
        }
    }

    public Object getTransformedMessage() throws TransformerException {
        if (this.isStreaming()) {
            return this.message.getAdapter();
        }
        if (this.transformedMessage == null) {
            UMOTransformer tran = this.endpoint.getTransformer();
            this.transformedMessage = tran != null ? tran.transform(this.message.getPayload()) : this.message.getPayload();
        }
        return this.transformedMessage;
    }

    public byte[] getTransformedMessageAsBytes() throws TransformerException {
        Object msg = this.getTransformedMessage();
        if (msg instanceof byte[]) {
            return (byte[])msg;
        }
        if (msg instanceof String) {
            try {
                return msg.toString().getBytes(this.getEncoding());
            }
            catch (UnsupportedEncodingException e) {
                throw new TransformerException(new Message(55, msg.getClass().getName(), (Object)e));
            }
        }
        if (msg instanceof Serializable) {
            try {
                return SerializationUtils.serialize((Serializable)((Serializable)msg));
            }
            catch (Exception e) {
                throw new TransformerException(new Message(110, msg.getClass().getName(), (Object)"byte[]"), (Throwable)e);
            }
        }
        throw new TransformerException(new Message(177, msg.getClass().getName(), (Object)("byte[] or " + Serializable.class.getName())));
    }

    public String getTransformedMessageAsString() throws TransformerException {
        return this.getTransformedMessageAsString(this.getEncoding());
    }

    public String getMessageAsString() throws UMOException {
        return this.getMessageAsString(this.getEncoding());
    }

    public String getTransformedMessageAsString(String encoding) throws TransformerException {
        try {
            return new String(this.getTransformedMessageAsBytes(), encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new TransformerException(this.endpoint.getTransformer(), (Throwable)e);
        }
    }

    public String getMessageAsString(String encoding) throws UMOException {
        try {
            return this.message.getPayloadAsString(encoding);
        }
        catch (Exception e) {
            throw new MuleException(new Message(70, this.message.getClass().getName()), (Throwable)e);
        }
    }

    public String getId() {
        return this.id;
    }

    public Object getProperty(String name) {
        return this.message.getProperty(name);
    }

    public Object getProperty(String name, Object defaultValue) {
        return this.message.getProperty(name, defaultValue);
    }

    public void setProperty(String name, Object value) {
        this.message.setProperty(name, value);
    }

    public UMOImmutableEndpoint getEndpoint() {
        return this.endpoint;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(64);
        buf.append("Event: ").append(this.getId());
        buf.append(", sync=").append(this.isSynchronous());
        buf.append(", stop processing=").append(this.isStopFurtherProcessing());
        buf.append(", ").append(this.endpoint);
        return buf.toString();
    }

    protected String generateEventId() {
        return UUID.getUUID();
    }

    public UMOSession getSession() {
        return this.session;
    }

    void setSession(UMOSession session) {
        this.session = session;
    }

    public UMOComponent getComponent() {
        return this.session.getComponent();
    }

    public boolean isStopFurtherProcessing() {
        return this.stopFurtherProcessing;
    }

    public void setStopFurtherProcessing(boolean stopFurtherProcessing) {
        this.stopFurtherProcessing = stopFurtherProcessing;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MuleEvent)) {
            return false;
        }
        MuleEvent event = (MuleEvent)o;
        if (this.message != null ? !this.message.equals(event.message) : event.message != null) {
            return false;
        }
        return this.id.equals(event.id);
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 29 * result + (this.message != null ? this.message.hashCode() : 0);
        return result;
    }

    public boolean isSynchronous() {
        return this.synchronous;
    }

    public void setSynchronous(boolean value) {
        this.synchronous = value;
    }

    public int getTimeout() {
        if (this.timeout == Integer.MIN_VALUE) {
            this.timeout = this.endpoint.getRemoteSyncTimeout();
        }
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getIntProperty(String name, int defaultValue) {
        return this.message.getIntProperty(name, defaultValue);
    }

    public long getLongProperty(String name, long defaultValue) {
        return this.message.getLongProperty(name, defaultValue);
    }

    public double getDoubleProperty(String name, double defaultValue) {
        return this.message.getDoubleProperty(name, defaultValue);
    }

    public boolean getBooleanProperty(String name, boolean defaultValue) {
        return this.message.getBooleanProperty(name, defaultValue);
    }

    public void setBooleanProperty(String name, boolean value) {
        this.message.setBooleanProperty(name, value);
    }

    public void setIntProperty(String name, int value) {
        this.message.setIntProperty(name, value);
    }

    public void setLongProperty(String name, long value) {
        this.message.setLongProperty(name, value);
    }

    public void setDoubleProperty(String name, double value) {
        this.message.setDoubleProperty(name, value);
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public Object removeProperty(String key) {
        return this.message.removeProperty(key);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.endpoint.getEndpointURI().toString());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        String uri = (String)in.readObject();
        try {
            this.endpoint = MuleEndpoint.getOrCreateEndpointForUri(uri, "sender");
        }
        catch (UMOException e) {
            throw (IOException)new IOException().initCause(e);
        }
    }

    public String getStringProperty(String name, String defaultValue) {
        return this.message.getStringProperty(name, defaultValue);
    }

    public void setStringProperty(String name, String value) {
        this.setProperty(name, value);
    }

    public boolean isStreaming() {
        return this.endpoint.isStreaming();
    }

    public String getEncoding() {
        String encoding = this.endpoint.getEncoding();
        if (encoding == null) {
            encoding = this.message.getEncoding();
        }
        if (encoding == null) {
            encoding = MuleManager.getConfiguration().getEncoding();
        }
        return encoding;
    }
}

