/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleManager;
import org.mule.config.i18n.Message;
import org.mule.impl.MuleEvent;
import org.mule.impl.MuleSessionHandler;
import org.mule.impl.RequestContext;
import org.mule.impl.endpoint.MuleEndpoint;
import org.mule.providers.AbstractConnector;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.UMOSession;
import org.mule.umo.endpoint.EndpointNotFoundException;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.provider.DispatchException;
import org.mule.umo.provider.ReceiveException;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.provider.UMOMessageDispatcher;
import org.mule.umo.provider.UMOSessionHandler;
import org.mule.umo.routing.UMOOutboundMessageRouter;
import org.mule.umo.security.UMOSecurityContext;
import org.mule.util.UUID;

public final class MuleSession
implements UMOSession {
    private static final long serialVersionUID = 3380926585676521866L;
    private static transient Log logger = LogFactory.getLog((Class)MuleSession.class);
    private UMOComponent component = null;
    private boolean valid = true;
    private String id;
    private UMOSecurityContext securityContext;
    private Map properties = null;

    public MuleSession(UMOComponent component) {
        this.properties = new HashMap();
        this.id = UUID.getUUID();
        this.component = component;
    }

    public MuleSession(UMOMessage message, UMOSessionHandler requestSessionHandler, UMOComponent component) throws UMOException {
        this(message, requestSessionHandler);
        if (component == null) {
            throw new IllegalArgumentException(new Message(183, "component").toString());
        }
        this.component = component;
    }

    public MuleSession(UMOMessage message, UMOSessionHandler requestSessionHandler) throws UMOException {
        if (requestSessionHandler == null) {
            throw new IllegalArgumentException(new Message(183, "requestSessionHandler").toString());
        }
        if (message == null) {
            throw new IllegalArgumentException(new Message(183, "message").toString());
        }
        this.properties = new HashMap();
        requestSessionHandler.populateSession(message, this);
        this.id = (String)this.getProperty(requestSessionHandler.getSessionIDKey());
        if (this.id == null) {
            this.id = UUID.getUUID();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("There is no session id on the request using key: " + requestSessionHandler.getSessionIDKey() + ". Generating new session id: " + this.id));
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("Got session with id: " + this.id));
        }
    }

    public void dispatchEvent(UMOMessage message) throws UMOException {
        UMOOutboundMessageRouter router = this.component.getDescriptor().getOutboundRouter();
        if (router == null) {
            throw new EndpointNotFoundException(new Message(101, this.component.getDescriptor().getName()));
        }
        router.route(message, this, false);
    }

    public void dispatchEvent(UMOMessage message, String endpointName) throws UMOException {
        this.dispatchEvent(message, MuleManager.getInstance().lookupEndpoint(endpointName));
    }

    public void dispatchEvent(UMOMessage message, UMOImmutableEndpoint endpoint) throws UMOException {
        if (this.component == null) {
            throw new IllegalStateException(new Message(45, "Component").getMessage());
        }
        if (endpoint == null) {
            endpoint = this.component.getDescriptor().getOutboundEndpoint();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Session has received asynchronous event on: " + endpoint));
        }
        UMOEvent event = this.createOutboundEvent(message, endpoint, RequestContext.getEvent());
        this.dispatchEvent(event);
    }

    public UMOMessage sendEvent(UMOMessage message, String endpointName) throws UMOException {
        return this.sendEvent(message, MuleManager.getInstance().lookupEndpoint(endpointName));
    }

    public UMOMessage sendEvent(UMOMessage message) throws UMOException {
        UMOOutboundMessageRouter router = this.component.getDescriptor().getOutboundRouter();
        if (router == null) {
            throw new EndpointNotFoundException(new Message(101, this.component.getDescriptor().getName()));
        }
        return router.route(message, this, true);
    }

    public UMOMessage sendEvent(UMOMessage message, UMOImmutableEndpoint endpoint) throws UMOException {
        UMOEvent event;
        UMOMessage result;
        if (this.component == null) {
            throw new IllegalStateException(new Message(45, "Component").getMessage());
        }
        if (endpoint == null) {
            endpoint = this.component.getDescriptor().getOutboundEndpoint();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Session has received synchronous event on endpoint: " + endpoint));
        }
        if ((result = this.sendEvent(event = this.createOutboundEvent(message, endpoint, RequestContext.getEvent()))) != null) {
            RequestContext.rewriteEvent(result);
        }
        return result;
    }

    public void dispatchEvent(UMOEvent event) throws UMOException {
        if (event.getEndpoint().canSend()) {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("dispatching event: " + event));
                }
                UMOConnector connector = event.getEndpoint().getConnector();
                UMOMessageDispatcher dispatcher = connector.getDispatcher(event.getEndpoint());
                if (connector instanceof AbstractConnector) {
                    ((AbstractConnector)connector).getSessionHandler().writeSession(event.getMessage(), this);
                } else {
                    logger.warn((Object)"A session handler could not be obtained, using  default");
                    new MuleSessionHandler().writeSession(event.getMessage(), this);
                }
                dispatcher.dispatch(event);
            }
            catch (Exception e) {
                throw new DispatchException(event.getMessage(), event.getEndpoint(), (Throwable)e);
            }
        } else if (this.component != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("dispatching event to component: " + this.component.getDescriptor().getName() + ", event is: " + event));
            }
            this.component.dispatchEvent(event);
        } else {
            throw new DispatchException(new Message(64), event.getMessage(), event.getEndpoint());
        }
    }

    public String getId() {
        return this.id;
    }

    public UMOMessage sendEvent(UMOEvent event) throws UMOException {
        int timeout = event.getMessage().getIntProperty("MULE_EVENT_TIMEOUT", -1);
        if (timeout >= 0) {
            event.setTimeout(timeout);
        }
        if (event.getEndpoint().canSend()) {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("sending event: " + event));
                }
                UMOConnector connector = event.getEndpoint().getConnector();
                UMOMessageDispatcher dispatcher = connector.getDispatcher(event.getEndpoint());
                if (connector instanceof AbstractConnector) {
                    ((AbstractConnector)connector).getSessionHandler().writeSession(event.getMessage(), this);
                } else {
                    logger.warn((Object)"A session handler could not be obtained, using default.");
                    new MuleSessionHandler().writeSession(event.getMessage(), this);
                }
                return dispatcher.send(event);
            }
            catch (UMOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new DispatchException(event.getMessage(), event.getEndpoint(), (Throwable)e);
            }
        }
        if (this.component != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("dispatching event to component: " + this.component.getDescriptor().getName() + " event is: " + event));
            }
            return this.component.sendEvent(event);
        }
        throw new DispatchException(new Message(64), event.getMessage(), event.getEndpoint());
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean value) {
        this.valid = value;
    }

    public UMOMessage receiveEvent(String endpointName, long timeout) throws UMOException {
        UMOEndpoint endpoint = MuleEndpoint.getOrCreateEndpointForUri(endpointName, "receiver");
        return this.receiveEvent(endpoint, timeout);
    }

    public UMOMessage receiveEvent(UMOImmutableEndpoint endpoint, long timeout) throws UMOException {
        try {
            UMOMessageDispatcher dispatcher = endpoint.getConnector().getDispatcher(endpoint);
            return dispatcher.receive(endpoint, timeout);
        }
        catch (Exception e) {
            throw new ReceiveException(endpoint, timeout, e);
        }
    }

    public UMOEvent createOutboundEvent(UMOMessage message, UMOImmutableEndpoint endpoint, UMOEvent previousEvent) throws UMOException {
        if (endpoint == null) {
            throw new DispatchException(new Message(45, "Outbound Endpoint"), message, endpoint);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Creating event with data: " + message.getPayload().getClass().getName() + ", for endpoint: " + endpoint));
        }
        if (endpoint.getTransformer() == null && endpoint instanceof UMOEndpoint && endpoint.getConnector() instanceof AbstractConnector) {
            ((UMOEndpoint)endpoint).setTransformer(((AbstractConnector)endpoint.getConnector()).getDefaultOutboundTransformer());
            logger.debug((Object)("Using default connector outbound transformer: " + endpoint.getTransformer()));
        }
        try {
            MuleEvent event = previousEvent != null ? new MuleEvent(message, endpoint, this.component, previousEvent) : new MuleEvent(message, endpoint, (UMOSession)this, false, null);
            return event;
        }
        catch (Exception e) {
            throw new DispatchException(new Message(65, "Event"), message, endpoint, e);
        }
    }

    public UMOComponent getComponent() {
        return this.component;
    }

    void setComponent(UMOComponent component) {
        this.component = component;
    }

    public void setSecurityContext(UMOSecurityContext context) {
        this.securityContext = context;
    }

    public UMOSecurityContext getSecurityContext() {
        return this.securityContext;
    }

    public void setProperty(Object key, Object value) {
        this.properties.put(key, value);
    }

    public Object getProperty(Object key) {
        return this.properties.get(key);
    }

    public Object removeProperty(Object key) {
        return this.properties.remove(key);
    }

    public Iterator getPropertyNames() {
        return this.properties.keySet().iterator();
    }
}

