/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.endpoint;

import java.util.Map;
import org.mule.config.i18n.Message;
import org.mule.impl.ImmutableMuleEndpoint;
import org.mule.umo.UMOException;
import org.mule.umo.UMOFilter;
import org.mule.umo.UMOTransactionConfig;
import org.mule.umo.endpoint.EndpointException;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.security.UMOEndpointSecurityFilter;
import org.mule.umo.transformer.UMOTransformer;

public class MuleEndpoint
extends ImmutableMuleEndpoint
implements UMOEndpoint {
    private static final long serialVersionUID = 2028442057178326047L;
    public static final String ALWAYS_CREATE_STRING = "ALWAYS_CREATE";
    public static final String NEVER_CREATE_STRING = "NEVER_CREATE";

    public MuleEndpoint() {
        super(null, null, null, null, "senderAndReceiver", 0, null, null);
    }

    public MuleEndpoint(String name, UMOEndpointURI endpointUri, UMOConnector connector, UMOTransformer transformer, String type, int createConnector, String endpointEncoding, Map props) {
        super(name, endpointUri, connector, transformer, type, createConnector, endpointEncoding, props);
    }

    public MuleEndpoint(UMOImmutableEndpoint endpoint) {
        super(endpoint);
    }

    public MuleEndpoint(String endpointName, boolean receiver) throws UMOException {
        super(endpointName, receiver);
    }

    public Object clone() {
        MuleEndpoint clone = new MuleEndpoint(this.name, this.endpointUri, this.connector, this.transformer, this.type, this.createConnector, this.endpointEncoding, this.properties);
        clone.setTransactionConfig(this.transactionConfig);
        clone.setFilter(this.filter);
        clone.setSecurityFilter(this.securityFilter);
        if (this.remoteSync != null) {
            clone.setRemoteSync(this.isRemoteSync());
        }
        if (this.remoteSyncTimeout != null) {
            clone.setRemoteSyncTimeout(this.getRemoteSyncTimeout());
        }
        if (this.synchronous != null) {
            clone.setSynchronous(this.synchronous);
        }
        clone.setDeleteUnacceptedMessages(this.deleteUnacceptedMessages);
        clone.setInitialState(this.initialState);
        if (this.initialised.get()) {
            try {
                clone.initialise();
            }
            catch (InitialisationException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return clone;
    }

    public void setEndpointURI(UMOEndpointURI endpointUri) throws EndpointException {
        if (this.connector != null && endpointUri != null && !this.connector.supportsProtocol(endpointUri.getFullScheme())) {
            throw new IllegalArgumentException(new Message(206, this.connector.getProtocol(), (Object)endpointUri).getMessage());
        }
        this.endpointUri = endpointUri;
        if (endpointUri != null) {
            this.properties.putAll(endpointUri.getParams());
        }
    }

    public void setEncoding(String endpointEncoding) {
        this.endpointEncoding = endpointEncoding;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setConnector(UMOConnector connector) {
        if (connector != null && this.endpointUri != null && !connector.supportsProtocol(this.endpointUri.getFullScheme())) {
            throw new IllegalArgumentException(new Message(206, connector.getProtocol(), (Object)this.endpointUri).getMessage());
        }
        this.connector = connector;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTransformer(UMOTransformer trans) {
        this.transformer = trans;
        if (this.transformer != null) {
            this.transformer.setEndpoint(this);
        }
    }

    public void setProperties(Map props) {
        this.properties.clear();
        this.properties.putAll(props);
    }

    public boolean isReadOnly() {
        return false;
    }

    public void setTransactionConfig(UMOTransactionConfig config) {
        this.transactionConfig = config;
    }

    public void setFilter(UMOFilter filter) {
        this.filter = filter;
    }

    public void setDeleteUnacceptedMessages(boolean delete) {
        this.deleteUnacceptedMessages = delete;
    }

    public void setSecurityFilter(UMOEndpointSecurityFilter filter) {
        this.securityFilter = filter;
        if (this.securityFilter != null) {
            this.securityFilter.setEndpoint(this);
        }
    }

    public void setSynchronous(boolean synchronous) {
        this.synchronous = synchronous;
    }

    public void setCreateConnector(int action) {
        this.createConnector = action;
    }

    public void setCreateConnectorAsString(String action) {
        this.createConnector = ALWAYS_CREATE_STRING.equals(action) ? 1 : (NEVER_CREATE_STRING.equals(action) ? 2 : 0);
    }

    public void setRemoteSync(boolean value) {
        this.remoteSync = value;
        if (value) {
            this.synchronous = Boolean.TRUE;
        }
    }

    public void setRemoteSyncTimeout(int timeout) {
        this.remoteSyncTimeout = new Integer(timeout);
    }

    public void setInitialState(String state) {
        this.initialState = state;
    }

    public void setResponseTransformer(UMOTransformer trans) {
        this.responseTransformer = trans;
    }

    public void setStreaming(boolean stream) {
        this.streaming = stream;
    }

    public void setProperty(String key, Object value) {
        this.properties.put(key, value);
    }
}

