/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.internal.admin;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleManager;
import org.mule.impl.AlreadyInitialisedException;
import org.mule.impl.endpoint.MuleEndpointURI;
import org.mule.impl.internal.admin.MuleManagerComponent;
import org.mule.providers.service.ConnectorFactory;
import org.mule.umo.UMODescriptor;
import org.mule.umo.UMOException;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.manager.UMOAgent;
import org.mule.umo.manager.UMOManager;
import org.mule.umo.provider.UMOConnector;

public class MuleAdminAgent
implements UMOAgent {
    public static final String DEFAULT_MANAGER_ENDPOINT = "_muleManagerEndpoint";
    public static final String AGENT_NAME = "Mule Admin";
    protected static transient Log logger = LogFactory.getLog((Class)MuleAdminAgent.class);
    private String serverEndpoint;

    public String getName() {
        return AGENT_NAME;
    }

    public void setName(String name) {
    }

    public String getDescription() {
        return this.getName() + ": accepting connections on " + this.serverEndpoint;
    }

    public void start() throws UMOException {
    }

    public void stop() throws UMOException {
    }

    public void dispose() {
    }

    public void registered() {
    }

    public void unregistered() {
    }

    public void initialise() throws InitialisationException {
        this.serverEndpoint = MuleManager.getConfiguration().getServerUrl();
        UMOManager manager = MuleManager.getInstance();
        try {
            if (StringUtils.isEmpty((String)this.serverEndpoint)) {
                logger.warn((Object)"No serverEndpointUrl specified, MuleAdminAgent will not start. E.g. use <mule-environment-properties serverUrl=\"tcp://example.com:60504\"/> ");
                manager.unregisterAgent(this.getName());
                return;
            }
            if (manager.getModel().isComponentRegistered("_muleManagerComponent")) {
                logger.info((Object)"Mule manager component has already been initialised, ignoring server url");
            } else {
                if (manager.lookupConnector(DEFAULT_MANAGER_ENDPOINT) != null) {
                    throw new AlreadyInitialisedException("Server Components", (Object)this);
                }
                MuleEndpointURI endpointUri = new MuleEndpointURI(this.serverEndpoint);
                UMOConnector connector = ConnectorFactory.getOrCreateConnectorByProtocol(endpointUri);
                if (manager.lookupConnector(connector.getName()) == null) {
                    connector.setName(DEFAULT_MANAGER_ENDPOINT);
                    connector.initialise();
                    manager.registerConnector(connector);
                }
                logger.info((Object)("Registering Admin listener on: " + this.serverEndpoint));
                UMODescriptor descriptor = MuleManagerComponent.getDescriptor(connector, endpointUri);
                manager.getModel().registerComponent(descriptor);
            }
        }
        catch (UMOException e) {
            throw new InitialisationException(e, (Object)this);
        }
    }

    public String toString() {
        return "MuleAdminAgent{serverEndpoint='" + this.serverEndpoint + "'" + "}";
    }
}

