/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.internal.admin;

import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleException;
import org.mule.MuleManager;
import org.mule.config.i18n.Message;
import org.mule.impl.MuleDescriptor;
import org.mule.impl.MuleEvent;
import org.mule.impl.MuleMessage;
import org.mule.impl.RequestContext;
import org.mule.impl.endpoint.MuleEndpoint;
import org.mule.impl.endpoint.MuleEndpointURI;
import org.mule.impl.internal.notifications.AdminNotification;
import org.mule.impl.message.ExceptionPayload;
import org.mule.providers.AbstractConnector;
import org.mule.providers.NullPayload;
import org.mule.transformers.xml.ObjectToXml;
import org.mule.transformers.xml.XmlToObject;
import org.mule.umo.UMODescriptor;
import org.mule.umo.UMOEventContext;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.UMOSession;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.lifecycle.Callable;
import org.mule.umo.lifecycle.Initialisable;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.provider.UMOMessageDispatcher;
import org.mule.umo.transformer.TransformerException;
import org.mule.umo.transformer.UMOTransformer;

public class MuleManagerComponent
implements Callable,
Initialisable {
    protected static transient Log logger = LogFactory.getLog((Class)MuleManagerComponent.class);
    public static final String MANAGER_COMPONENT_NAME = "_muleManagerComponent";
    public static final String MANAGER_ENDPOINT_NAME = "_muleManagerEndpoint";
    private XmlToObject remoteTransformer;
    private ObjectToXml objectToXml;

    public void initialise() throws InitialisationException {
        this.objectToXml = new ObjectToXml();
        this.remoteTransformer = new XmlToObject();
        this.remoteTransformer.setReturnClass(AdminNotification.class);
    }

    public Object onCall(UMOEventContext context) throws Exception {
        Object result = null;
        String xml = context.getMessageAsString();
        logger.debug((Object)"Message received by MuleManagerComponent");
        AdminNotification action = (AdminNotification)this.remoteTransformer.transform(xml);
        result = 604 == action.getAction() ? this.invokeAction(action, context) : (603 == action.getAction() ? this.sendAction(action, context) : (602 == action.getAction() ? this.sendAction(action, context) : (601 == action.getAction() ? this.receiveAction(action, context) : this.handleException(null, new MuleException(new Message(166, "AdminNotification:" + action.getAction()))))));
        return result;
    }

    protected Object invokeAction(AdminNotification action, UMOEventContext context) throws UMOException {
        String destComponent = null;
        UMOMessage result = null;
        String endpoint = action.getResourceIdentifier();
        destComponent = action.getResourceIdentifier().startsWith("mule:") ? endpoint.substring(endpoint.lastIndexOf("/") + 1) : endpoint;
        if (destComponent != null) {
            UMOSession session = MuleManager.getInstance().getModel().getComponentSession(destComponent);
            MuleEndpoint ep = new MuleEndpoint(RequestContext.getEvent().getEndpoint());
            ep.setTransformer(null);
            MuleEvent event = new MuleEvent(action.getMessage(), (UMOImmutableEndpoint)ep, context.getSession(), context.isSynchronous());
            RequestContext.setEvent(event);
            if (context.isSynchronous()) {
                result = session.getComponent().sendEvent(event);
                return this.objectToXml.transform(result);
            }
            session.getComponent().dispatchEvent(event);
            return null;
        }
        return this.handleException(result, new MuleException(new Message(198, endpoint)));
    }

    protected Object sendAction(AdminNotification action, UMOEventContext context) throws UMOException {
        UMOMessage result = null;
        try {
            MuleEndpoint endpoint = new MuleEndpoint(action.getResourceIdentifier(), false);
            if (602 == action.getAction()) {
                context.dispatchEvent(action.getMessage(), endpoint);
                return null;
            }
            endpoint.setRemoteSync(true);
            result = context.sendEvent(action.getMessage(), endpoint);
            if (result == null) {
                return null;
            }
            return this.objectToXml.transform(result);
        }
        catch (Exception e) {
            return this.handleException(result, e);
        }
    }

    protected Object receiveAction(AdminNotification action, UMOEventContext context) throws UMOException {
        UMOMessage result = null;
        try {
            MuleEndpointURI endpointUri = new MuleEndpointURI(action.getResourceIdentifier());
            UMOEndpoint endpoint = MuleEndpoint.getOrCreateEndpointForUri(endpointUri, "sender");
            UMOMessageDispatcher dispatcher = endpoint.getConnector().getDispatcher(endpoint);
            long timeout = MapUtils.getLongValue((Map)action.getProperties(), (Object)"MULE_EVENT_TIMEOUT", (long)MuleManager.getConfiguration().getSynchronousEventTimeout());
            MuleEndpointURI ep = new MuleEndpointURI(action.getResourceIdentifier());
            result = dispatcher.receive(ep, timeout);
            if (result != null) {
                UMOTransformer trans = ((AbstractConnector)endpoint.getConnector()).getDefaultInboundTransformer();
                if (trans != null) {
                    Object payload = trans.transform(result.getPayload());
                    result = new MuleMessage(payload, result);
                }
                return this.objectToXml.transform(result);
            }
            return null;
        }
        catch (Exception e) {
            return this.handleException(result, e);
        }
    }

    public static final UMODescriptor getDescriptor(UMOConnector connector, UMOEndpointURI endpointUri) throws UMOException {
        MuleEndpoint endpoint = new MuleEndpoint();
        endpoint.setConnector(connector);
        endpoint.setEndpointURI(endpointUri);
        endpoint.setName(MANAGER_ENDPOINT_NAME);
        endpoint.setType("receiver");
        MuleDescriptor descriptor = new MuleDescriptor();
        descriptor.setName(MANAGER_COMPONENT_NAME);
        descriptor.setInboundEndpoint(endpoint);
        descriptor.setImplementation(MuleManagerComponent.class.getName());
        descriptor.setContainerManaged(false);
        return descriptor;
    }

    protected String handleException(UMOMessage result, Throwable e) {
        logger.error((Object)("Failed to process admin request: " + e.getMessage()), e);
        if (result == null) {
            result = new MuleMessage((Object)new NullPayload(), (Map)null);
        }
        result.setExceptionPayload(new ExceptionPayload(e));
        try {
            return (String)this.objectToXml.transform(result);
        }
        catch (TransformerException e1) {
            logger.error((Object)e.toString(), e);
            return e.getMessage();
        }
    }
}

