/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.internal.notifications;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.impl.MuleMessage;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.manager.UMOServerNotification;
import org.mule.umo.provider.UMOConnectable;

public class MessageNotification
extends UMOServerNotification {
    private static final long serialVersionUID = -5118299601117624094L;
    protected static transient Log logger = LogFactory.getLog((Class)MessageNotification.class);
    public static final int MESSAGE_RECEIVED = 801;
    public static final int MESSAGE_DISPATCHED = 802;
    public static final int MESSAGE_SENT = 803;
    public static final int MESSAGE_REQUESTED = 804;
    private static final transient String[] ACTIONS = new String[]{"received", "dispatched", "sent", "requested"};
    private UMOImmutableEndpoint endpoint;

    public MessageNotification(UMOMessage resource, UMOImmutableEndpoint endpoint, String identifier, int action) {
        super(MessageNotification.cloneMessage(resource), action);
        this.resourceIdentifier = identifier;
        this.endpoint = endpoint;
    }

    protected static UMOMessage cloneMessage(UMOMessage message) {
        Object clonePayload = message.getPayload();
        MuleMessage clone = new MuleMessage(clonePayload, message);
        return clone;
    }

    protected String getPayloadToString() {
        if (this.source instanceof UMOConnectable) {
            return ((UMOConnectable)this.source).getConnectionDescription();
        }
        return this.source.toString();
    }

    protected String getActionName(int action) {
        int i = action - 800;
        if (i - 1 > ACTIONS.length) {
            return String.valueOf(action);
        }
        return ACTIONS[i - 1];
    }

    public String toString() {
        return this.EVENT_NAME + "{action=" + this.getActionName(this.action) + ", endpoint: " + this.endpoint.getEndpointURI() + ", resourceId=" + this.resourceIdentifier + ", timestamp=" + this.timestamp + ", serverId=" + this.serverId + ", message: " + this.source + "}";
    }

    public UMOImmutableEndpoint getEndpoint() {
        return this.endpoint;
    }
}

