/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.model;

import org.mule.impl.MuleDescriptor;
import org.mule.impl.model.AbstractComponent;
import org.mule.umo.ComponentException;
import org.mule.umo.UMOAsynchronousComponent;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.model.UMOModel;
import org.mule.util.concurrent.WaitableBoolean;

public abstract class AbstractAsynchronousComponent
extends AbstractComponent
implements UMOAsynchronousComponent {
    protected WaitableBoolean paused = new WaitableBoolean(false);

    public AbstractAsynchronousComponent(MuleDescriptor descriptor, UMOModel model) {
        super(descriptor, model);
    }

    public final void pause() {
        this.doPause();
        this.paused.set(true);
        this.fireComponentNotification(304);
    }

    public final void resume() {
        this.doResume();
        this.paused.set(false);
        this.fireComponentNotification(305);
    }

    public boolean isPaused() {
        return this.paused.get();
    }

    protected void doPause() {
    }

    protected void doResume() {
    }

    public UMOMessage sendEvent(UMOEvent event) throws UMOException {
        if (this.logger.isDebugEnabled() && this.paused.get()) {
            this.logger.debug((Object)("Component: " + this.descriptor.getName() + " is paused. Blocking call until resume is called"));
        }
        try {
            this.paused.whenFalse(null);
        }
        catch (InterruptedException e) {
            throw new ComponentException(event.getMessage(), this, (Throwable)e);
        }
        return super.sendEvent(event);
    }
}

