/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.model;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import java.beans.ExceptionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleManager;
import org.mule.config.i18n.Message;
import org.mule.impl.DefaultComponentExceptionStrategy;
import org.mule.impl.MuleDescriptor;
import org.mule.impl.RequestContext;
import org.mule.impl.internal.notifications.ComponentNotification;
import org.mule.impl.model.ComponentUtil;
import org.mule.management.stats.ComponentStatistics;
import org.mule.umo.ComponentException;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMODescriptor;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.model.UMOModel;
import org.mule.umo.provider.DispatchException;
import org.mule.umo.provider.UMOMessageDispatcher;
import org.mule.util.concurrent.WaitableBoolean;

public abstract class AbstractComponent
implements UMOComponent {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    protected MuleDescriptor descriptor = null;
    protected ComponentStatistics stats = null;
    protected AtomicBoolean stopped = new AtomicBoolean(true);
    protected WaitableBoolean stopping = new WaitableBoolean(false);
    protected AtomicBoolean poolInitialised = new AtomicBoolean(false);
    protected ExceptionListener exceptionListener = null;
    protected AtomicBoolean initialised = new AtomicBoolean(false);
    protected UMOModel model;

    public AbstractComponent(MuleDescriptor descriptor, UMOModel model) {
        if (descriptor == null) {
            throw new IllegalArgumentException("Descriptor cannot be null");
        }
        this.descriptor = descriptor;
        this.model = MuleManager.getInstance().getModel();
    }

    public final synchronized void initialise() throws InitialisationException {
        if (this.initialised.get()) {
            throw new InitialisationException(new Message(37, "Component '" + this.descriptor.getName() + "'"), (Object)this);
        }
        this.descriptor.initialise();
        this.exceptionListener = this.descriptor.getExceptionListener();
        this.stats = new ComponentStatistics(this.getName(), this.descriptor.getPoolingProfile().getMaxActive(), this.descriptor.getThreadingProfile().getMaxThreadsActive());
        this.stats.setEnabled(((MuleManager)MuleManager.getInstance()).getStatistics().isEnabled());
        ((MuleManager)MuleManager.getInstance()).getStatistics().add(this.stats);
        this.stats.setOutboundRouterStat(this.getDescriptor().getOutboundRouter().getStatistics());
        this.stats.setInboundRouterStat(this.getDescriptor().getInboundRouter().getStatistics());
        this.doInitialise();
        this.initialised.set(true);
        this.fireComponentNotification(301);
    }

    protected void fireComponentNotification(int action) {
        MuleManager.getInstance().fireNotification(new ComponentNotification(this.descriptor, action));
    }

    void finaliseEvent(UMOEvent event) {
        this.logger.debug((Object)("Finalising event for: " + this.descriptor.getName() + " event endpointUri is: " + event.getEndpoint().getEndpointURI()));
    }

    public void forceStop() throws UMOException {
        if (!this.stopped.get()) {
            this.logger.debug((Object)"Stopping UMOComponent");
            this.stopping.set(true);
            this.fireComponentNotification(307);
            this.doForceStop();
            this.stopped.set(true);
            this.stopping.set(false);
            this.fireComponentNotification(303);
        }
    }

    public void stop() throws UMOException {
        if (!this.stopped.get()) {
            this.logger.debug((Object)"Stopping UMOComponent");
            this.stopping.set(true);
            this.fireComponentNotification(307);
            if (MuleManager.getInstance().getQueueManager().getQueueSession().getQueue(this.descriptor.getName() + ".component").size() > 0) {
                try {
                    this.stopping.whenFalse(null);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.doStop();
            this.stopped.set(true);
            this.fireComponentNotification(303);
        }
    }

    public void start() throws UMOException {
        if (this.stopped.get()) {
            this.stopped.set(false);
            this.doStart();
        }
        this.fireComponentNotification(302);
    }

    public final void dispose() {
        try {
            if (!this.stopped.get()) {
                this.stop();
            }
        }
        catch (UMOException e) {
            this.logger.error((Object)("Failed to stop component: " + this.descriptor.getName()), (Throwable)e);
        }
        this.doDispose();
        this.fireComponentNotification(306);
        ((MuleManager)MuleManager.getInstance()).getStatistics().remove(this.stats);
    }

    public ComponentStatistics getStatistics() {
        return this.stats;
    }

    public UMODescriptor getDescriptor() {
        return this.descriptor;
    }

    public void dispatchEvent(UMOEvent event) throws UMOException {
        if (this.stopping.get() || this.stopped.get()) {
            throw new ComponentException(new Message(167, this.getDescriptor().getName()), event.getMessage(), this);
        }
        if (!event.getEndpoint().canReceive()) {
            UMOMessageDispatcher dispatcher = event.getEndpoint().getConnector().getDispatcher(event.getEndpoint());
            try {
                dispatcher.dispatch(event);
            }
            catch (Exception e) {
                throw new DispatchException(event.getMessage(), event.getEndpoint(), (Throwable)e);
            }
            return;
        }
        if (this.stats.isEnabled()) {
            this.stats.incReceivedEventASync();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Component: " + this.descriptor.getName() + " has received asynchronous event on: " + event.getEndpoint().getEndpointURI()));
        }
        this.doDispatch(event);
    }

    public UMOMessage sendEvent(UMOEvent event) throws UMOException {
        if (this.stopping.get() || this.stopped.get()) {
            throw new ComponentException(new Message(167, this.getDescriptor().getName()), event.getMessage(), this);
        }
        if (this.stats.isEnabled()) {
            this.stats.incReceivedEventSync();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Component: " + this.descriptor.getName() + " has received synchronous event on: " + event.getEndpoint().getEndpointURI()));
        }
        RequestContext.setEvent(event);
        return this.doSend(event);
    }

    public String getName() {
        return this.descriptor.getName();
    }

    public String toString() {
        return this.descriptor.getName();
    }

    public boolean isStopped() {
        return this.stopped.get();
    }

    public boolean isStopping() {
        return this.stopping.get();
    }

    protected void handleException(Exception e) {
        if (this.exceptionListener instanceof DefaultComponentExceptionStrategy && ((DefaultComponentExceptionStrategy)this.exceptionListener).getComponent() == null) {
            ((DefaultComponentExceptionStrategy)this.exceptionListener).setComponent(this);
        }
        this.exceptionListener.exceptionThrown(e);
    }

    protected Object lookupComponent() throws UMOException {
        return ComponentUtil.createComponent(this.descriptor);
    }

    protected void doForceStop() throws UMOException {
    }

    protected void doStop() throws UMOException {
    }

    protected void doStart() throws UMOException {
    }

    protected void doDispose() {
    }

    protected void doInitialise() throws InitialisationException {
    }

    public boolean isStarted() {
        return !this.stopped.get();
    }

    protected abstract UMOMessage doSend(UMOEvent var1) throws UMOException;

    protected abstract void doDispatch(UMOEvent var1) throws UMOException;

    public Object getInstance() throws UMOException {
        return this.lookupComponent();
    }
}

