/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.mule.MuleManager;
import org.mule.config.i18n.Message;
import org.mule.impl.MuleDescriptor;
import org.mule.impl.container.ContainerKeyPair;
import org.mule.providers.AbstractConnector;
import org.mule.providers.AbstractMessageReceiver;
import org.mule.umo.ComponentException;
import org.mule.umo.UMOAsynchronousComponent;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOException;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.manager.UMOManager;
import org.mule.umo.model.ModelException;

public class ComponentUtil {
    public static void start(UMOComponent component) throws UMOException {
        ComponentUtil.start(component, false);
    }

    public static void start(UMOComponent component, boolean paused) throws UMOException {
        ComponentUtil.registerListeners(component);
        ComponentUtil.connectListeners(component);
        component.start();
        if (paused) {
            ComponentUtil.pause(component);
        }
        ComponentUtil.startListeners(component);
    }

    public static void stop(UMOComponent component) throws UMOException {
        ComponentUtil.unregisterListeners(component);
        component.stop();
    }

    public static void pause(UMOComponent component) throws UMOException {
        if (!UMOAsynchronousComponent.class.isAssignableFrom(component.getClass())) {
            throw new ComponentException(Message.createStaticMessage("Component " + component + " cannot be paused because it does not implement UMOAsynchronousComponent."), null, component);
        }
        ((UMOAsynchronousComponent)component).pause();
    }

    public static void resume(UMOComponent component) throws UMOException {
        if (!UMOAsynchronousComponent.class.isAssignableFrom(component.getClass())) {
            throw new ComponentException(Message.createStaticMessage("Component " + component + " cannot be resumed because it does not implement UMOAsynchronousComponent."), null, component);
        }
        ((UMOAsynchronousComponent)component).resume();
    }

    public static void registerListeners(UMOComponent component) throws UMOException {
        List endpoints = ComponentUtil.getIncomingEndpoints(component);
        Iterator it = endpoints.iterator();
        while (it.hasNext()) {
            UMOEndpoint endpoint = (UMOEndpoint)it.next();
            try {
                endpoint.getConnector().registerListener(component, endpoint);
            }
            catch (UMOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ModelException(new Message(47, component.getDescriptor().getName(), (Object)endpoint.getEndpointURI()), (Throwable)e);
            }
        }
    }

    public static void unregisterListeners(UMOComponent component) throws UMOException {
        List endpoints = ComponentUtil.getIncomingEndpoints(component);
        Iterator it = endpoints.iterator();
        while (it.hasNext()) {
            UMOEndpoint endpoint = (UMOEndpoint)it.next();
            try {
                endpoint.getConnector().unregisterListener(component, endpoint);
            }
            catch (UMOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ModelException(new Message(48, component.getDescriptor().getName(), (Object)endpoint.getEndpointURI()), (Throwable)e);
            }
        }
    }

    public static void startListeners(UMOComponent component) throws UMOException {
        List endpoints = ComponentUtil.getIncomingEndpoints(component);
        Iterator it = endpoints.iterator();
        while (it.hasNext()) {
            UMOEndpoint endpoint = (UMOEndpoint)it.next();
            AbstractMessageReceiver receiver = ((AbstractConnector)endpoint.getConnector()).getReceiver(component, endpoint);
            if (receiver == null || !endpoint.getConnector().isStarted() || !endpoint.getInitialState().equals("started")) continue;
            receiver.start();
        }
    }

    public static void stopListeners(UMOComponent component) throws UMOException {
        List endpoints = ComponentUtil.getIncomingEndpoints(component);
        Iterator it = endpoints.iterator();
        while (it.hasNext()) {
            UMOEndpoint endpoint = (UMOEndpoint)it.next();
            AbstractMessageReceiver receiver = ((AbstractConnector)endpoint.getConnector()).getReceiver(component, endpoint);
            if (receiver == null) continue;
            receiver.stop();
        }
    }

    public static void connectListeners(UMOComponent component) throws UMOException {
        List endpoints = ComponentUtil.getIncomingEndpoints(component);
        Iterator it = endpoints.iterator();
        while (it.hasNext()) {
            UMOEndpoint endpoint = (UMOEndpoint)it.next();
            AbstractMessageReceiver receiver = ((AbstractConnector)endpoint.getConnector()).getReceiver(component, endpoint);
            if (receiver == null) continue;
            try {
                receiver.connect();
            }
            catch (Exception e) {
                throw new ModelException(Message.createStaticMessage("Failed to connect listener for endpoint " + endpoint.getName()), (Throwable)e);
            }
        }
    }

    public static void disconnectListeners(UMOComponent component) throws UMOException {
        List endpoints = ComponentUtil.getIncomingEndpoints(component);
        Iterator it = endpoints.iterator();
        while (it.hasNext()) {
            UMOEndpoint endpoint = (UMOEndpoint)it.next();
            AbstractMessageReceiver receiver = ((AbstractConnector)endpoint.getConnector()).getReceiver(component, endpoint);
            if (receiver == null) continue;
            try {
                receiver.disconnect();
            }
            catch (Exception e) {
                throw new ModelException(Message.createStaticMessage("Failed to connect listener for endpoint " + endpoint.getName()), (Throwable)e);
            }
        }
    }

    public static List getIncomingEndpoints(UMOComponent component) {
        ArrayList<UMOEndpoint> endpoints = new ArrayList<UMOEndpoint>();
        endpoints.addAll(component.getDescriptor().getInboundRouter().getEndpoints());
        if (component.getDescriptor().getInboundEndpoint() != null) {
            endpoints.add(component.getDescriptor().getInboundEndpoint());
        }
        if (component.getDescriptor().getResponseRouter() != null && component.getDescriptor().getResponseRouter().getEndpoints() != null) {
            endpoints.addAll(component.getDescriptor().getResponseRouter().getEndpoints());
        }
        return endpoints;
    }

    public static Object createComponent(MuleDescriptor descriptor) throws UMOException {
        UMOManager manager = MuleManager.getInstance();
        Object impl = descriptor.getImplementation();
        Object component = null;
        if (impl instanceof String) {
            impl = new ContainerKeyPair(null, impl);
        }
        if (impl instanceof ContainerKeyPair) {
            component = manager.getContainerContext().getComponent(impl);
            if (descriptor.isSingleton()) {
                descriptor.setImplementation(component);
            }
        } else {
            component = impl;
        }
        try {
            BeanUtils.populate((Object)component, (Map)descriptor.getProperties());
        }
        catch (Exception e) {
            throw new InitialisationException(new Message(83, "Component '" + descriptor.getName() + "'"), e, descriptor);
        }
        descriptor.fireInitialisationCallbacks(component);
        return component;
    }
}

