/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.model;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.mule.impl.model.ModelServiceNotFoundException;
import org.mule.providers.service.ConnectorFactory;
import org.mule.umo.model.UMOModel;
import org.mule.util.BeanUtils;
import org.mule.util.ClassUtils;
import org.mule.util.SpiUtils;

public class ModelFactory {
    public static final String MODEL_SERVICE_PATH = "org/mule/models";

    public static UMOModel createModel(String type) throws ModelServiceNotFoundException {
        String location = "META-INF/services/org/mule/models";
        InputStream is = SpiUtils.findServiceDescriptor(MODEL_SERVICE_PATH, type, ConnectorFactory.class);
        try {
            if (is != null) {
                Properties props = new Properties();
                props.load(is);
                String clazz = props.getProperty("model");
                try {
                    UMOModel model = (UMOModel)ClassUtils.instanciateClass(clazz, ClassUtils.NO_ARGS, ModelFactory.class);
                    BeanUtils.populateWithoutFail(model, props, false);
                    return model;
                }
                catch (Exception e) {
                    throw new ModelServiceNotFoundException(location + "/" + type, (Throwable)e);
                }
            }
            throw new ModelServiceNotFoundException(location + "/" + type);
        }
        catch (IOException e) {
            throw new ModelServiceNotFoundException(location + "/" + type, (Throwable)e);
        }
    }
}

