/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.space;

import edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArrayList;
import java.util.Iterator;
import java.util.List;
import org.mule.impl.space.AbstractSpace;
import org.mule.impl.space.SpaceTransactionException;
import org.mule.umo.space.UMOSpaceException;
import org.mule.util.queue.Queue;
import org.mule.util.queue.QueueConfiguration;
import org.mule.util.queue.QueueManager;
import org.mule.util.queue.QueuePersistenceStrategy;
import org.mule.util.queue.QueueSession;
import org.mule.util.queue.TransactionalQueueManager;
import org.mule.util.xa.ResourceManagerException;
import org.mule.util.xa.ResourceManagerSystemException;

public class DefaultSpace
extends AbstractSpace {
    private Queue space;
    private QueueSession session;
    private QueueManager queueManager;
    private boolean localQueueManager = false;
    private List children = new CopyOnWriteArrayList();
    private String parentName;

    DefaultSpace(String name, QueuePersistenceStrategy ps, int capacity) throws ResourceManagerSystemException {
        this(name, ps, true, capacity);
    }

    public DefaultSpace(String name, QueuePersistenceStrategy ps, boolean enableMonitorEvents, int capacity) throws ResourceManagerSystemException {
        super(name, enableMonitorEvents);
        this.queueManager = new TransactionalQueueManager();
        this.localQueueManager = true;
        this.queueManager.setPersistenceStrategy(ps);
        this.queueManager.setQueueConfiguration(name, new QueueConfiguration(capacity, !ps.isTransient()));
        this.session = this.queueManager.getQueueSession();
        this.space = this.session.getQueue(name);
        this.queueManager.start();
    }

    public DefaultSpace(String name, QueueManager qm, boolean enableMonitorEvents) {
        super(name, enableMonitorEvents);
        this.queueManager = qm;
        this.session = this.queueManager.getQueueSession();
        this.space = this.session.getQueue(name);
    }

    protected DefaultSpace(String name, String parentName, QueueManager queueManager, QueueSession session, boolean enableMonitorEvents) {
        super(parentName + "." + name, enableMonitorEvents);
        this.queueManager = queueManager;
        this.session = session;
        this.space = session.getQueue(parentName);
        this.localQueueManager = false;
        this.parentName = parentName;
    }

    public void doPut(Object item) throws UMOSpaceException {
        try {
            this.space.put(item);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void doPut(Object item, long lease) throws UMOSpaceException {
        try {
            this.space.put(item);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
    }

    public Object doTake() throws UMOSpaceException {
        try {
            return this.space.take();
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    public Object doTake(long timeout) throws UMOSpaceException {
        try {
            return this.space.poll(timeout);
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    public Object doTakeNoWait() throws UMOSpaceException {
        try {
            return this.space.poll(1L);
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    protected void doDispose() {
        Iterator iterator = this.children.iterator();
        while (iterator.hasNext()) {
            DefaultSpace childSpace = (DefaultSpace)iterator.next();
            childSpace.dispose();
        }
        this.children.clear();
        if (this.localQueueManager) {
            try {
                this.queueManager.stop();
            }
            catch (ResourceManagerSystemException e) {
                this.logger.warn((Object)e);
            }
        }
    }

    public int size() {
        return this.space.size();
    }

    public void beginTransaction() throws UMOSpaceException {
        try {
            this.session.begin();
        }
        catch (ResourceManagerException e) {
            throw new SpaceTransactionException(e);
        }
    }

    public void commitTransaction() throws UMOSpaceException {
        try {
            this.session.commit();
        }
        catch (ResourceManagerException e) {
            throw new SpaceTransactionException(e);
        }
    }

    public void rollbackTransaction() throws UMOSpaceException {
        try {
            this.session.rollback();
        }
        catch (ResourceManagerException e) {
            throw new SpaceTransactionException(e);
        }
    }

    public DefaultSpace createChild(String name) {
        DefaultSpace child = new DefaultSpace(name, this.parentName == null ? this.name : this.parentName, this.queueManager, this.session, this.enableMonitorEvents);
        this.logger.info((Object)("created child space: " + child.getName()));
        this.children.add(child);
        return child;
    }

    public String getParentName() {
        return this.parentName;
    }
}

