/*
 * Decompiled with CFR 0.152.
 */
package org.mule.management.agents;

import java.util.Iterator;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.apache.log4j.jmx.HierarchyDynamicMBean;
import org.mule.config.i18n.Message;
import org.mule.umo.UMOException;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.manager.UMOAgent;

public class Log4jAgent
implements UMOAgent {
    private String name = "Log4j Agent";
    private MBeanServer mBeanServer;
    public static final String JMX_OBJECT_NAME = "log4j:type=Hierarchy";

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return "Log4j JMX Agent";
    }

    public void initialise() throws InitialisationException {
        try {
            this.mBeanServer = MBeanServerFactory.findMBeanServer(null).get(0);
            ObjectName objectName = ObjectName.getInstance(JMX_OBJECT_NAME);
            this.unregisterMBeansIfNecessary();
            this.mBeanServer.registerMBean(new HierarchyDynamicMBean(), objectName);
        }
        catch (Exception e) {
            throw new InitialisationException(new Message(42, "JMX Agent"), e, this);
        }
    }

    protected void unregisterMBeansIfNecessary() throws MalformedObjectNameException, InstanceNotFoundException, MBeanRegistrationException {
        if (this.mBeanServer.isRegistered(ObjectName.getInstance(JMX_OBJECT_NAME))) {
            Set<ObjectInstance> log4jMBeans = this.mBeanServer.queryMBeans(ObjectName.getInstance("log4j*:*"), null);
            Iterator<ObjectInstance> it = log4jMBeans.iterator();
            while (it.hasNext()) {
                ObjectInstance objectInstance = it.next();
                ObjectName theName = objectInstance.getObjectName();
                this.mBeanServer.unregisterMBean(theName);
            }
        }
    }

    public void start() throws UMOException {
    }

    public void stop() throws UMOException {
    }

    public void dispose() {
    }

    public void registered() {
    }

    public void unregistered() {
    }
}

