/*
 * Decompiled with CFR 0.152.
 */
package org.mule.management.agents;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import mx4j.log.CommonsLogger;
import mx4j.log.Log;
import mx4j.log.Logger;
import mx4j.tools.adaptor.AdaptorServerSocketFactory;
import mx4j.tools.adaptor.http.HttpAdaptor;
import mx4j.tools.adaptor.http.ProcessorMBean;
import mx4j.tools.adaptor.http.XSLTProcessor;
import mx4j.tools.adaptor.ssl.SSLAdaptorServerSocketFactory;
import org.mule.config.i18n.Message;
import org.mule.management.agents.JmxManagementException;
import org.mule.umo.UMOException;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.manager.UMOAgent;
import org.mule.util.BeanUtils;
import org.mule.util.StringUtils;

public class Mx4jAgent
implements UMOAgent {
    private String name = "MX4j  Agent";
    private String jmxAdaptorUrl = "http://localhost:9999";
    private Object adaptor;
    private MBeanServer mBeanServer;
    private ObjectName adaptorName;
    private String login = null;
    private String password = null;
    private String authenticationMethod = "basic";
    private String xslFilePath = null;
    private String pathInJar = null;
    private boolean cacheXsl = true;
    private Map socketFactoryProperties = new HashMap();

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getAuthenticationMethod() {
        return this.authenticationMethod;
    }

    public void setAuthenticationMethod(String authenticationMethod) {
        this.authenticationMethod = authenticationMethod;
    }

    public String getXslFilePath() {
        return this.xslFilePath;
    }

    public void setXslFilePath(String xslFilePath) {
        this.xslFilePath = xslFilePath;
    }

    public String getPathInJar() {
        return this.pathInJar;
    }

    public void setPathInJar(String pathInJar) {
        this.pathInJar = pathInJar;
    }

    public boolean isCacheXsl() {
        return this.cacheXsl;
    }

    public void setCacheXsl(boolean cacheXsl) {
        this.cacheXsl = cacheXsl;
    }

    protected Object createAdaptor() throws Exception {
        Log.redirectTo((Logger)new CommonsLogger());
        URI uri = new URI(StringUtils.stripToEmpty((String)this.jmxAdaptorUrl));
        HttpAdaptor adaptor = new HttpAdaptor(uri.getPort(), uri.getHost());
        XSLTProcessor processor = new XSLTProcessor();
        if (StringUtils.isNotBlank((String)this.xslFilePath)) {
            processor.setFile(this.xslFilePath.trim());
        }
        if (StringUtils.isNotBlank((String)this.pathInJar)) {
            processor.setPathInJar(this.pathInJar.trim());
        }
        processor.setUseCache(this.cacheXsl);
        HttpAdaptor httpAdaptor = adaptor;
        httpAdaptor.setProcessor((ProcessorMBean)processor);
        if (this.login != null) {
            httpAdaptor.addAuthorization(this.login, this.password);
            httpAdaptor.setAuthenticationMethod(this.authenticationMethod);
        }
        if (this.socketFactoryProperties != null && !this.socketFactoryProperties.isEmpty()) {
            SSLAdaptorServerSocketFactory factory = new SSLAdaptorServerSocketFactory();
            BeanUtils.populateWithoutFail(factory, this.socketFactoryProperties, true);
            httpAdaptor.setSocketFactory((AdaptorServerSocketFactory)factory);
        }
        return adaptor;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return "MX4J Http adaptor: " + this.jmxAdaptorUrl;
    }

    public void start() throws UMOException {
        try {
            this.mBeanServer.invoke(this.adaptorName, "start", null, null);
        }
        catch (InstanceNotFoundException e) {
            throw new JmxManagementException(new Message(42, "Mx4j agent"), this.adaptorName, e);
        }
        catch (MBeanException e) {
            throw new JmxManagementException(new Message(42, "Mx4j agent"), this.adaptorName, e);
        }
        catch (ReflectionException reflectionException) {
            // empty catch block
        }
    }

    public void stop() throws UMOException {
        try {
            this.mBeanServer.invoke(this.adaptorName, "stop", null, null);
        }
        catch (InstanceNotFoundException e) {
            throw new JmxManagementException(new Message(41, "Mx4j agent"), this.adaptorName, e);
        }
        catch (MBeanException e) {
            throw new JmxManagementException(new Message(41, "Mx4j agent"), this.adaptorName, e);
        }
        catch (ReflectionException reflectionException) {
            // empty catch block
        }
    }

    public void dispose() {
        try {
            this.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void registered() {
    }

    public void unregistered() {
    }

    public void initialise() throws InitialisationException {
        try {
            this.mBeanServer = MBeanServerFactory.findMBeanServer(null).get(0);
            this.adaptor = this.createAdaptor();
            this.adaptorName = new ObjectName("Adaptor:class=" + this.adaptor.getClass().getName());
            this.mBeanServer.registerMBean(this.adaptor, this.adaptorName);
        }
        catch (Exception e) {
            throw new InitialisationException(new Message(42, "mx4j agent"), (Object)e);
        }
    }

    public String getJmxAdaptorUrl() {
        return this.jmxAdaptorUrl;
    }

    public void setJmxAdaptorUrl(String jmxAdaptorUrl) {
        this.jmxAdaptorUrl = jmxAdaptorUrl;
    }

    public Map getSocketFactoryProperties() {
        return this.socketFactoryProperties;
    }

    public void setSocketFactoryProperties(Map socketFactoryProperties) {
        this.socketFactoryProperties = socketFactoryProperties;
    }
}

