/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentMap;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import java.beans.ExceptionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.resource.spi.work.WorkEvent;
import javax.resource.spi.work.WorkListener;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleManager;
import org.mule.MuleRuntimeException;
import org.mule.config.ThreadingProfile;
import org.mule.config.i18n.Message;
import org.mule.impl.AlreadyInitialisedException;
import org.mule.impl.DefaultExceptionStrategy;
import org.mule.impl.MuleSessionHandler;
import org.mule.impl.internal.notifications.ConnectionNotification;
import org.mule.management.mbeans.EndpointService;
import org.mule.providers.AbstractMessageReceiver;
import org.mule.providers.ConnectException;
import org.mule.providers.ConnectionStrategy;
import org.mule.providers.DefaultReplyToHandler;
import org.mule.providers.ReplyToHandler;
import org.mule.routing.filters.WildcardFilter;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOException;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.lifecycle.DisposeException;
import org.mule.umo.lifecycle.Initialisable;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.manager.UMOServerNotification;
import org.mule.umo.manager.UMOWorkManager;
import org.mule.umo.provider.ConnectorException;
import org.mule.umo.provider.UMOConnectable;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.provider.UMOMessageDispatcher;
import org.mule.umo.provider.UMOMessageDispatcherFactory;
import org.mule.umo.provider.UMOMessageReceiver;
import org.mule.umo.provider.UMOSessionHandler;
import org.mule.umo.transformer.UMOTransformer;
import org.mule.util.concurrent.WaitableBoolean;

public abstract class AbstractConnector
implements UMOConnector,
ExceptionListener,
UMOConnectable,
WorkListener {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    protected AtomicBoolean started = new AtomicBoolean(false);
    protected AtomicBoolean initialised = new AtomicBoolean(false);
    protected String name = null;
    protected ExceptionListener exceptionListener = null;
    protected AtomicBoolean disposed = new AtomicBoolean(false);
    protected AtomicBoolean disposing = new AtomicBoolean(false);
    protected UMOMessageDispatcherFactory dispatcherFactory;
    protected ConcurrentMap dispatchers;
    protected ConcurrentMap receivers;
    private ThreadingProfile dispatcherThreadingProfile = null;
    private ThreadingProfile receiverThreadingProfile = null;
    protected boolean createDispatcherPerRequest = false;
    protected boolean createMultipleTransactedReceivers = true;
    protected UMOTransformer defaultInboundTransformer = null;
    protected UMOTransformer defaultOutboundTransformer = null;
    protected UMOTransformer defaultResponseTransformer = null;
    private ConnectionStrategy connectionStrategy;
    protected WaitableBoolean connected = new WaitableBoolean(false);
    protected WaitableBoolean connecting = new WaitableBoolean(false);
    protected WaitableBoolean startOnConnect = new WaitableBoolean(false);
    private boolean enableMessageEvents = false;
    private List supportedProtocols;
    private UMOWorkManager receiverWorkManager = null;
    private UMOWorkManager dispatcherWorkManager = null;
    private boolean useSingleReceiverThreadPool = false;
    private boolean useSingleDispatcherThreadPool = false;
    protected boolean serverSide = true;
    protected UMOSessionHandler sessionHandler = new MuleSessionHandler();

    public AbstractConnector() {
        this.exceptionListener = new DefaultExceptionStrategy();
        this.dispatchers = new ConcurrentHashMap();
        this.receivers = new ConcurrentHashMap();
        this.connectionStrategy = MuleManager.getConfiguration().getConnectionStrategy();
        this.enableMessageEvents = MuleManager.getConfiguration().isEnableMessageEvents();
        this.supportedProtocols = new ArrayList();
        this.supportedProtocols.add(this.getProtocol().toLowerCase());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        if (newName == null) {
            throw new IllegalArgumentException(new Message(45, "Connector name").toString());
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Set UMOConnector name to: " + newName));
        }
        this.name = newName;
    }

    public final synchronized void initialise() throws InitialisationException {
        if (this.initialised.get()) {
            throw new AlreadyInitialisedException("Connector '" + this.getName() + "'", (Object)this);
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Initialising " + this.getClass().getName()));
        }
        this.doInitialise();
        if (this.exceptionListener instanceof Initialisable) {
            ((Initialisable)((Object)this.exceptionListener)).initialise();
        }
        this.initialised.set(true);
    }

    public abstract String getProtocol();

    public final void startConnector() throws UMOException {
        this.checkDisposed();
        if (!this.isStarted()) {
            if (!this.isConnected()) {
                this.startOnConnect.set(true);
                this.getConnectionStrategy().connect(this);
                return;
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Starting Connector: " + this.getClass().getName()));
            }
            this.doStart();
            this.started.set(true);
            if (this.receivers != null) {
                Iterator iterator = this.receivers.values().iterator();
                while (iterator.hasNext()) {
                    AbstractMessageReceiver amr = (AbstractMessageReceiver)iterator.next();
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Starting receiver on endpoint: " + amr.getEndpoint().getEndpointURI()));
                    }
                    amr.start();
                }
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Connector: " + this.getClass().getName() + " has been started"));
            }
        }
    }

    public boolean isStarted() {
        return this.started.get();
    }

    public final void stopConnector() throws UMOException {
        if (this.isDisposed()) {
            return;
        }
        if (this.isStarted()) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Stopping Connector: " + this.getClass().getName()));
            }
            this.doStop();
            this.started.set(false);
            if (this.receivers != null) {
                Iterator iterator = this.receivers.values().iterator();
                while (iterator.hasNext()) {
                    UMOMessageReceiver mr = (UMOMessageReceiver)iterator.next();
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Stopping receiver on endpoint: " + mr.getEndpoint().getEndpointURI()));
                    }
                    mr.stop();
                }
            }
        }
        if (this.isConnected()) {
            try {
                this.disconnect();
            }
            catch (Exception e) {
                this.logger.error((Object)("Failed to disconnect: " + e.getMessage()), (Throwable)e);
            }
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Connector " + this.getClass().getName() + " has been stopped"));
        }
    }

    public final synchronized void dispose() {
        this.disposing.set(true);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Disposing Connector: " + this.getClass().getName()));
            this.logger.debug((Object)"Disposing Receivers");
        }
        this.disposeReceivers();
        this.disposeDispatchers();
        this.doDispose();
        this.disposed.set(true);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Connector " + this.getClass().getName() + " has been disposed."));
        }
    }

    protected void disposeReceivers() {
        if (this.receivers != null) {
            Iterator iterator = this.receivers.values().iterator();
            while (iterator.hasNext()) {
                UMOMessageReceiver receiver = (UMOMessageReceiver)iterator.next();
                try {
                    this.destroyReceiver(receiver, receiver.getEndpoint());
                }
                catch (Throwable e) {
                    this.logger.error((Object)("Failed to destroy receiver: " + e.getMessage()), e);
                }
            }
            this.receivers.clear();
            this.receivers = null;
            this.logger.debug((Object)"Receivers Disposed");
        }
    }

    protected void disposeDispatchers() {
        if (this.dispatchers != null) {
            this.logger.debug((Object)"Disposing Dispatchers");
            Iterator iterator = this.dispatchers.values().iterator();
            while (iterator.hasNext()) {
                UMOMessageDispatcher umoMessageDispatcher = (UMOMessageDispatcher)iterator.next();
                umoMessageDispatcher.dispose();
            }
            this.dispatchers.clear();
            this.logger.debug((Object)"Dispatchers Disposed");
        }
    }

    public boolean isDisposed() {
        return this.disposed.get();
    }

    public void handleException(Exception exception) {
        if (this.exceptionListener == null) {
            throw new MuleRuntimeException(new Message(146, this.getName()), (Throwable)exception);
        }
        this.exceptionListener.exceptionThrown(exception);
    }

    public void exceptionThrown(Exception e) {
        this.handleException(e);
    }

    public ExceptionListener getExceptionListener() {
        return this.exceptionListener;
    }

    public void setExceptionListener(ExceptionListener listener) {
        this.exceptionListener = listener;
    }

    public UMOMessageDispatcherFactory getDispatcherFactory() {
        return this.dispatcherFactory;
    }

    public void setDispatcherFactory(UMOMessageDispatcherFactory dispatcherFactory) {
        this.dispatcherFactory = dispatcherFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UMOMessageDispatcher getDispatcher(UMOImmutableEndpoint endpoint) throws UMOException {
        this.checkDisposed();
        if (endpoint == null) {
            throw new IllegalArgumentException("Endpoint must not be null");
        }
        if (!this.supportsProtocol(endpoint.getConnector().getProtocol())) {
            throw new IllegalArgumentException(new Message(206, this.getProtocol(), (Object)endpoint.getEndpointURI().toString()).getMessage());
        }
        if (this.dispatchers == null) {
            throw new IllegalStateException("Dispatchers are null for connector: " + this.name);
        }
        UMOImmutableEndpoint uMOImmutableEndpoint = endpoint;
        synchronized (uMOImmutableEndpoint) {
            String endpointUriKey = endpoint.getEndpointURI().toString();
            UMOMessageDispatcher dispatcher = (UMOMessageDispatcher)this.dispatchers.get((Object)endpointUriKey);
            if (dispatcher == null || dispatcher.isDisposed()) {
                dispatcher = this.createDispatcher(endpoint);
                this.dispatchers.put((Object)endpointUriKey, (Object)dispatcher);
            }
            return dispatcher;
        }
    }

    protected void checkDisposed() throws DisposeException {
        if (this.isDisposed()) {
            throw new DisposeException(new Message(32), (Object)this);
        }
    }

    protected UMOMessageDispatcher createDispatcher(UMOImmutableEndpoint endpoint) throws UMOException {
        if (this.dispatcherFactory == null) {
            throw new ConnectorException(new Message(36, this.name), this);
        }
        return this.dispatcherFactory.create(endpoint);
    }

    public UMOMessageReceiver registerListener(UMOComponent component, UMOEndpoint endpoint) throws Exception {
        if (endpoint == null) {
            throw new IllegalArgumentException("The endpoint cannot be null when registering a listener");
        }
        if (component == null) {
            throw new IllegalArgumentException("The component cannot be null when registering a listener");
        }
        UMOEndpointURI endpointUri = endpoint.getEndpointURI();
        if (endpointUri == null) {
            throw new ConnectorException(new Message(34), this);
        }
        this.logger.info((Object)("registering listener: " + component.getDescriptor().getName() + " on endpointUri: " + endpointUri.toString()));
        UMOMessageReceiver receiver = this.getReceiver(component, endpoint);
        if (receiver != null) {
            throw new ConnectorException(new Message(35, endpointUri), this);
        }
        receiver = this.createReceiver(component, endpoint);
        this.receivers.put(this.getReceiverKey(component, endpoint), (Object)receiver);
        return receiver;
    }

    protected Object getReceiverKey(UMOComponent component, UMOEndpoint endpoint) {
        return StringUtils.defaultIfEmpty((String)endpoint.getEndpointURI().getFilterAddress(), (String)endpoint.getEndpointURI().getAddress());
    }

    public final void unregisterListener(UMOComponent component, UMOEndpoint endpoint) throws Exception {
        UMOMessageReceiver receiver;
        if (component == null) {
            throw new IllegalArgumentException("The component must not be null when you unregister a listener");
        }
        if (endpoint == null) {
            throw new IllegalArgumentException("The endpoint must not be null when you unregister a listener");
        }
        UMOEndpointURI endpointUri = endpoint.getEndpointURI();
        if (endpointUri == null) {
            throw new IllegalArgumentException("The endpointUri must not be null when you unregister a listener");
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("removing listener on endpointUri: " + endpointUri));
        }
        if ((receiver = (UMOMessageReceiver)this.receivers.remove(this.getReceiverKey(component, endpoint))) != null) {
            this.destroyReceiver(receiver, endpoint);
            receiver.dispose();
        }
    }

    public ThreadingProfile getDispatcherThreadingProfile() {
        if (this.dispatcherThreadingProfile == null) {
            this.dispatcherThreadingProfile = MuleManager.getConfiguration().getMessageDispatcherThreadingProfile();
        }
        return this.dispatcherThreadingProfile;
    }

    public void setDispatcherThreadingProfile(ThreadingProfile dispatcherThreadingProfile) {
        this.dispatcherThreadingProfile = dispatcherThreadingProfile;
    }

    public ThreadingProfile getReceiverThreadingProfile() {
        if (this.receiverThreadingProfile == null) {
            this.receiverThreadingProfile = MuleManager.getConfiguration().getMessageReceiverThreadingProfile();
        }
        return this.receiverThreadingProfile;
    }

    public void setReceiverThreadingProfile(ThreadingProfile receiverThreadingProfile) {
        this.receiverThreadingProfile = receiverThreadingProfile;
    }

    public abstract UMOMessageReceiver createReceiver(UMOComponent var1, UMOEndpoint var2) throws Exception;

    public void destroyReceiver(UMOMessageReceiver receiver, UMOEndpoint endpoint) throws Exception {
        receiver.dispose();
    }

    protected void doStart() throws UMOException {
    }

    protected void doStop() throws UMOException {
    }

    protected void doDispose() {
        try {
            this.stopConnector();
        }
        catch (UMOException e) {
            this.logger.warn((Object)("Failed to stop during shutdown: " + e.getMessage()), (Throwable)e);
        }
    }

    public void doInitialise() throws InitialisationException {
    }

    public UMOTransformer getDefaultInboundTransformer() {
        if (this.defaultInboundTransformer != null) {
            try {
                return (UMOTransformer)this.defaultInboundTransformer.clone();
            }
            catch (CloneNotSupportedException e) {
                this.logger.error((Object)"Failed to clone default Inbound transformer");
                return null;
            }
        }
        return null;
    }

    public void setDefaultInboundTransformer(UMOTransformer defaultInboundTransformer) {
        this.defaultInboundTransformer = defaultInboundTransformer;
    }

    public UMOTransformer getDefaultResponseTransformer() {
        if (this.defaultResponseTransformer != null) {
            try {
                return (UMOTransformer)this.defaultResponseTransformer.clone();
            }
            catch (CloneNotSupportedException e) {
                this.logger.error((Object)"Failed to clone default Outbound transformer");
                return null;
            }
        }
        return null;
    }

    public UMOTransformer getDefaultOutboundTransformer() {
        if (this.defaultOutboundTransformer != null) {
            try {
                return (UMOTransformer)this.defaultOutboundTransformer.clone();
            }
            catch (CloneNotSupportedException e) {
                this.logger.error((Object)"Failed to clone default Outbound transformer");
                return null;
            }
        }
        return null;
    }

    public void setDefaultOutboundTransformer(UMOTransformer defaultOutboundTransformer) {
        this.defaultOutboundTransformer = defaultOutboundTransformer;
    }

    public void setDefaultResponseTransformer(UMOTransformer defaultResponseTransformer) {
        this.defaultResponseTransformer = defaultResponseTransformer;
    }

    public ReplyToHandler getReplyToHandler() {
        return new DefaultReplyToHandler(this.defaultResponseTransformer);
    }

    public Map getDispatchers() {
        return this.dispatchers;
    }

    public void fireNotification(UMOServerNotification notification) {
        MuleManager.getInstance().fireNotification(notification);
    }

    public ConnectionStrategy getConnectionStrategy() {
        try {
            return (ConnectionStrategy)BeanUtils.cloneBean((Object)this.connectionStrategy);
        }
        catch (Exception e) {
            throw new MuleRuntimeException(new Message(145, "connectionStrategy"), (Throwable)e);
        }
    }

    public void setConnectionStrategy(ConnectionStrategy connectionStrategy) {
        this.connectionStrategy = connectionStrategy;
    }

    public List getEndpointMBeans() {
        ArrayList<EndpointService> beans = new ArrayList<EndpointService>(this.receivers.size());
        Iterator iterator = this.receivers.values().iterator();
        while (iterator.hasNext()) {
            UMOMessageReceiver receiver = (UMOMessageReceiver)iterator.next();
            beans.add(new EndpointService(receiver));
        }
        return beans;
    }

    public boolean isDisposing() {
        return this.disposing.get();
    }

    public boolean isRemoteSyncEnabled() {
        return false;
    }

    public AbstractMessageReceiver getReceiver(UMOComponent component, UMOEndpoint endpoint) {
        return (AbstractMessageReceiver)this.receivers.get(this.getReceiverKey(component, endpoint));
    }

    public Map getReceivers() {
        return Collections.unmodifiableMap(this.receivers);
    }

    public AbstractMessageReceiver getReceiver(String key) {
        return (AbstractMessageReceiver)this.receivers.get((Object)key);
    }

    public AbstractMessageReceiver[] getReceivers(String wildcardExpression) {
        ArrayList<Object> temp = new ArrayList<Object>();
        WildcardFilter filter = new WildcardFilter(wildcardExpression);
        filter.setCaseSensitive(false);
        Iterator iterator = this.receivers.keySet().iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            if (!filter.accept(o)) continue;
            temp.add(this.receivers.get(o));
        }
        AbstractMessageReceiver[] result = new AbstractMessageReceiver[temp.size()];
        return temp.toArray(result);
    }

    public void connect() throws Exception {
        if (this.connected.get()) {
            return;
        }
        this.checkDisposed();
        if (this.connecting.commit(false, true)) {
            this.connectionStrategy.connect(this);
            this.logger.info((Object)("Connected: " + this.getConnectionDescription()));
            return;
        }
        try {
            this.doConnect();
            this.fireNotification(new ConnectionNotification(this, this.getConnectEventId(), 701));
        }
        catch (Exception e) {
            this.fireNotification(new ConnectionNotification(this, this.getConnectEventId(), 702));
            if (e instanceof ConnectException) {
                throw (ConnectException)e;
            }
            throw new ConnectException(e, (Object)this);
        }
        this.connected.set(true);
        this.connecting.set(false);
        if (this.startOnConnect.get()) {
            this.startConnector();
        } else {
            Iterator iterator = this.receivers.values().iterator();
            while (iterator.hasNext()) {
                AbstractMessageReceiver amr = (AbstractMessageReceiver)iterator.next();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Connecting receiver on endpoint: " + amr.getEndpoint().getEndpointURI()));
                }
                amr.connect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() throws Exception {
        this.startOnConnect.set(this.isStarted());
        this.fireNotification(new ConnectionNotification(this, this.getConnectEventId(), 703));
        this.connected.set(false);
        try {
            this.doDisconnect();
        }
        finally {
            this.stopConnector();
        }
        this.logger.info((Object)("Disconnected: " + this.getConnectionDescription()));
    }

    public String getConnectionDescription() {
        return this.toString();
    }

    public final boolean isConnected() {
        return this.connected.get();
    }

    public void doConnect() throws Exception {
    }

    public void doDisconnect() throws Exception {
    }

    protected String getConnectEventId() {
        return this.getName();
    }

    public void setCreateDispatcherPerRequest(boolean createDispatcherPerRequest) {
        this.createDispatcherPerRequest = createDispatcherPerRequest;
    }

    public boolean isCreateDispatcherPerRequest() {
        return this.createDispatcherPerRequest;
    }

    public boolean isCreateMultipleTransactedReceivers() {
        return this.createMultipleTransactedReceivers;
    }

    public void setCreateMultipleTransactedReceivers(boolean createMultipleTransactedReceivers) {
        this.createMultipleTransactedReceivers = createMultipleTransactedReceivers;
    }

    public boolean isEnableMessageEvents() {
        return this.enableMessageEvents;
    }

    public void setEnableMessageEvents(boolean enableMessageEvents) {
        this.enableMessageEvents = enableMessageEvents;
    }

    public void registerSupportedProtocol(String protocol) {
        if ((protocol = protocol.toLowerCase()).startsWith(this.getProtocol().toLowerCase())) {
            this.registerSupportedProtocolWithotPrefix(protocol);
        } else {
            this.supportedProtocols.add(this.getProtocol().toLowerCase() + ":" + protocol);
        }
    }

    protected void registerSupportedProtocolWithotPrefix(String protocol) {
        this.supportedProtocols.add(protocol.toLowerCase());
    }

    public void unregisterSupportedProtocol(String protocol) {
        if ((protocol = protocol.toLowerCase()).startsWith(this.getProtocol().toLowerCase())) {
            this.supportedProtocols.remove(protocol);
        } else {
            this.supportedProtocols.remove(this.getProtocol().toLowerCase() + ":" + protocol);
        }
    }

    public boolean supportsProtocol(String protocol) {
        return this.supportedProtocols.contains(protocol.toLowerCase());
    }

    public List getSupportedProtocols() {
        return Collections.unmodifiableList(this.supportedProtocols);
    }

    public void setSupportedProtocols(List supportedProtocols) {
        Iterator iterator = supportedProtocols.iterator();
        while (iterator.hasNext()) {
            String s = (String)iterator.next();
            this.registerSupportedProtocol(s);
        }
    }

    UMOWorkManager createReceiverWorkManager(String name) {
        UMOWorkManager wm;
        if (this.useSingleReceiverThreadPool && this.receiverWorkManager != null) {
            wm = this.receiverWorkManager;
        } else {
            ThreadingProfile tp = this.getReceiverThreadingProfile();
            if (this.serverSide) {
                tp.setThreadPriority(7);
            }
            wm = tp.createWorkManager(this.getName() + "." + name + ".receiver");
            if (this.useSingleReceiverThreadPool) {
                this.receiverWorkManager = wm;
            }
        }
        return wm;
    }

    UMOWorkManager createDispatcherWorkManager(String name) {
        UMOWorkManager wm = null;
        if (this.useSingleDispatcherThreadPool && this.dispatcherWorkManager != null) {
            wm = this.dispatcherWorkManager;
        } else {
            ThreadingProfile tp = this.getReceiverThreadingProfile();
            wm = tp.createWorkManager(this.getName() + "." + name + ".dispatcher");
            if (this.useSingleDispatcherThreadPool) {
                this.dispatcherWorkManager = wm;
            }
        }
        return wm;
    }

    public boolean isUseSingleReceiverThreadPool() {
        return this.useSingleReceiverThreadPool;
    }

    public void setUseSingleReceiverThreadPool(boolean useSingleReceiverThreadPool) {
        this.useSingleReceiverThreadPool = useSingleReceiverThreadPool;
    }

    public boolean isUseSingleDispatcherThreadPool() {
        return this.useSingleDispatcherThreadPool;
    }

    public void setUseSingleDispatcherThreadPool(boolean useSingleDispatcherThreadPool) {
        this.useSingleDispatcherThreadPool = useSingleDispatcherThreadPool;
    }

    public boolean isServerSide() {
        return this.serverSide;
    }

    public void setServerSide(boolean serverSide) {
        this.serverSide = serverSide;
    }

    public UMOSessionHandler getSessionHandler() {
        return this.sessionHandler;
    }

    public void setSessionHandler(UMOSessionHandler sessionHandler) {
        this.sessionHandler = sessionHandler;
    }

    public void workAccepted(WorkEvent event) {
        this.handleWorkException(event, "workAccepted");
    }

    public void workRejected(WorkEvent event) {
        this.handleWorkException(event, "workRejected");
    }

    public void workStarted(WorkEvent event) {
        this.handleWorkException(event, "workStarted");
    }

    public void workCompleted(WorkEvent event) {
        this.handleWorkException(event, "workCompleted");
    }

    protected void handleWorkException(WorkEvent event, String type) {
        if (event == null || event.getException() == null) {
            return;
        }
        Throwable e = event.getException();
        if (event.getException().getCause() != null) {
            e = event.getException().getCause();
        }
        this.logger.error((Object)("Work caused exception on '" + type + "'. Work being executed was: " + event.getWork().toString()));
        if (!(e instanceof Exception)) {
            throw new MuleRuntimeException(new Message(33, this.getName()), e);
        }
        this.handleException((Exception)e);
    }
}

