/*
 * Decompiled with CFR 0.152.
 */
package org.mule.registry.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.mule.registry.Library;
import org.mule.registry.Registry;
import org.mule.registry.RegistryComponent;
import org.mule.registry.RegistryDescriptor;
import org.mule.registry.RegistryException;
import org.mule.registry.impl.AbstractEntry;
import org.mule.util.FileUtils;

public abstract class AbstractLibrary
extends AbstractEntry
implements Library {
    protected List components = new ArrayList();
    protected List classPathElements;
    protected boolean isClassLoaderParentFirst;
    protected RegistryDescriptor descriptor;

    protected AbstractLibrary(Registry registry) {
        super(registry);
    }

    public RegistryComponent[] getComponents() {
        ArrayList<RegistryComponent> c = new ArrayList<RegistryComponent>();
        Iterator it = this.components.iterator();
        while (it.hasNext()) {
            String ref = (String)it.next();
            RegistryComponent comp = this.getRegistry().getComponent(ref);
            c.add(comp);
        }
        return c.toArray(new RegistryComponent[c.size()]);
    }

    public void addComponent(RegistryComponent component) {
        this.components.add(component.getName());
    }

    public void removeComponent(RegistryComponent component) {
        this.components.remove(component.getName());
    }

    protected void checkDescriptor() throws RegistryException {
        super.checkDescriptor();
        if (!this.getDescriptor().isSharedLibrary()) {
            throw new RegistryException("shared library should be set");
        }
    }

    public synchronized void install() throws RegistryException {
        if (!this.getCurrentState().equals("Unknown")) {
            throw new RegistryException("Illegal status: " + this.getCurrentState());
        }
        try {
            this.doInstall();
        }
        catch (Exception e) {
            throw new RegistryException(e);
        }
        this.setCurrentState("Shutdown");
    }

    public synchronized void uninstall() throws RegistryException {
        if (!this.getCurrentState().equals("Shutdown")) {
            throw new RegistryException("Illegal status: " + this.getCurrentState());
        }
        try {
            this.doUninstall();
        }
        catch (Exception e) {
            throw new RegistryException(e);
        }
        FileUtils.deleteTree(new File(this.getInstallRoot()));
        this.getRegistry().removeLibrary(this);
        this.setCurrentState("Unknown");
    }

    public List getClassPathElements() {
        return this.classPathElements;
    }

    public boolean isClassLoaderParentFirst() {
        return this.isClassLoaderParentFirst;
    }

    public void setDescriptor(RegistryDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    protected abstract void doInstall() throws Exception;

    protected abstract void doUninstall() throws Exception;
}

