/*
 * Decompiled with CFR 0.152.
 */
package org.mule.registry.store;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.StaxDriver;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.mule.ManagementContext;
import org.mule.registry.Registry;
import org.mule.registry.RegistryException;
import org.mule.registry.RegistryFactory;
import org.mule.registry.RegistryStore;
import org.mule.registry.impl.AbstractRegistry;

public class XmlRegistryStore
implements RegistryStore {
    protected ManagementContext context;
    private static transient XStream xstream;

    public XmlRegistryStore(ManagementContext context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(Registry registry) throws RegistryException {
        Registry registry2 = registry;
        synchronized (registry2) {
            try {
                FileWriter w = new FileWriter(new File(registry.getStoreLocation()));
                XmlRegistryStore.getXStream().toXML((Object)registry, (Writer)w);
                ((Writer)w).close();
            }
            catch (Exception e) {
                throw new RegistryException("Could not save registry", (Throwable)e);
            }
        }
    }

    public Registry load(String storeLocation) throws RegistryException {
        try {
            FileReader r = new FileReader(storeLocation);
            AbstractRegistry reg = (AbstractRegistry)XmlRegistryStore.getXStream().fromXML((Reader)r);
            reg.initialize();
            reg.setStoreLocation(storeLocation);
            ((Reader)r).close();
            return reg;
        }
        catch (IOException e) {
            throw new RegistryException("Could not load registry", (Throwable)e);
        }
    }

    public Registry create(String store, RegistryFactory factory) throws RegistryException {
        Registry reg = factory.create(this, this.context);
        if (reg instanceof AbstractRegistry) {
            ((AbstractRegistry)reg).initialize();
            ((AbstractRegistry)reg).setStoreLocation(store);
        }
        this.save(reg);
        return reg;
    }

    private static XStream getXStream() {
        if (xstream == null) {
            xstream = new XStream((HierarchicalStreamDriver)new StaxDriver());
        }
        return xstream;
    }
}

