/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.inbound;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import java.util.Map;
import org.mule.impl.MuleEvent;
import org.mule.impl.endpoint.MuleEndpoint;
import org.mule.routing.AggregationException;
import org.mule.routing.inbound.EventGroup;
import org.mule.routing.inbound.SelectiveConsumer;
import org.mule.umo.MessagingException;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOImmutableEndpoint;

public abstract class AbstractEventAggregator
extends SelectiveConsumer {
    protected static final String NO_CORRELATION_ID = "no-id";
    protected Map eventGroups = new ConcurrentHashMap();
    private final Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UMOEvent[] process(UMOEvent event) throws MessagingException {
        AtomicBoolean doAggregate = new AtomicBoolean(false);
        EventGroup eg = null;
        if (this.isMatch(event)) {
            eg = this.addEvent(event);
            doAggregate.compareAndSet(false, this.shouldAggregate(eg));
        }
        if (doAggregate.get()) {
            Object object = this.lock;
            synchronized (object) {
                UMOMessage returnMessage = this.aggregateEvents(eg);
                this.removeGroup(eg.getGroupId());
                MuleEndpoint endpoint = new MuleEndpoint(event.getEndpoint());
                endpoint.setTransformer(null);
                endpoint.setName(this.getClass().getName());
                MuleEvent returnEvent = new MuleEvent(returnMessage, (UMOImmutableEndpoint)endpoint, event.getComponent(), event);
                return new UMOEvent[]{returnEvent};
            }
        }
        return null;
    }

    protected EventGroup addEvent(UMOEvent event) {
        EventGroup eg;
        String cId = event.getMessage().getCorrelationId();
        if (cId == null) {
            cId = NO_CORRELATION_ID;
        }
        if ((eg = (EventGroup)this.eventGroups.get(cId)) == null) {
            eg = new EventGroup(cId);
            eg.addEvent(event);
            this.eventGroups.put(eg.getGroupId(), eg);
        } else {
            eg.addEvent(event);
        }
        return eg;
    }

    protected void removeGroup(Object id) {
        this.eventGroups.remove(id);
    }

    protected abstract boolean shouldAggregate(EventGroup var1);

    protected abstract UMOMessage aggregateEvents(EventGroup var1) throws AggregationException;
}

