/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.inbound;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.io.IOUtils;
import org.mule.impl.MuleMessage;
import org.mule.routing.AggregationException;
import org.mule.routing.inbound.CorrelationAggregator;
import org.mule.routing.inbound.EventGroup;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOMessage;

public class MessageChunkingAggregator
extends CorrelationAggregator {
    protected UMOMessage aggregateEvents(EventGroup events) throws AggregationException {
        List eventList = IteratorUtils.toList((Iterator)events.iterator(), (int)events.size());
        UMOEvent firstEvent = (UMOEvent)eventList.get(0);
        Collections.sort(eventList, SequenceComparator.getInstance());
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
        try {
            Iterator iterator = eventList.iterator();
            while (iterator.hasNext()) {
                UMOEvent event = (UMOEvent)iterator.next();
                baos.write(event.getMessageAsBytes());
            }
            MuleMessage message = new MuleMessage((Object)baos.toByteArray(), firstEvent.getMessage());
            message.setCorrelationGroupSize(-1);
            message.setCorrelationSequence(-1);
            MuleMessage muleMessage = message;
            return muleMessage;
        }
        catch (Exception e) {
            throw new AggregationException(events, firstEvent.getEndpoint(), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)baos);
        }
    }

    public static class SequenceComparator
    implements Comparator {
        private static SequenceComparator _instance = new SequenceComparator();

        public static SequenceComparator getInstance() {
            return _instance;
        }

        private SequenceComparator() {
        }

        public int compare(Object o1, Object o2) {
            UMOEvent event1 = (UMOEvent)o1;
            UMOEvent event2 = (UMOEvent)o2;
            if (event1.getMessage().getCorrelationSequence() > event2.getMessage().getCorrelationSequence()) {
                return 1;
            }
            return -1;
        }
    }
}

