/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import java.util.List;
import org.mule.config.i18n.Message;
import org.mule.routing.outbound.FilteringOutboundRouter;
import org.mule.umo.UMOException;
import org.mule.umo.UMOExceptionPayload;
import org.mule.umo.UMOMessage;
import org.mule.umo.UMOSession;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.routing.CouldNotRouteOutboundMessageException;
import org.mule.umo.routing.RoutePathNotFoundException;
import org.mule.umo.routing.RoutingException;

public class ExceptionBasedRouter
extends FilteringOutboundRouter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UMOMessage route(UMOMessage message, UMOSession session, boolean synchronous) throws RoutingException {
        UMOMessage result = null;
        int endpointsCount = this.endpoints.size();
        if (this.endpoints == null || endpointsCount == 0) {
            throw new RoutePathNotFoundException(new Message(89), message, null);
        }
        if (this.enableCorrelation != 2) {
            boolean correlationSet;
            boolean bl = correlationSet = message.getCorrelationId() != null;
            if (correlationSet && this.enableCorrelation == 0) {
                this.logger.debug((Object)"CorrelationId is already set, not setting Correlation group size");
            } else {
                message.setCorrelationGroupSize(endpointsCount);
            }
        }
        UMOEndpoint endpoint = null;
        boolean success = false;
        List list = this.endpoints;
        synchronized (list) {
            for (int i = 0; i < endpointsCount; ++i) {
                boolean lastEndpoint;
                endpoint = this.getEndpoint(i, message);
                boolean bl = lastEndpoint = i == endpointsCount - 1;
                if (!lastEndpoint) {
                    this.logger.info((Object)("Sync mode will be forced for " + endpoint.getEndpointURI() + ", as there are more endpoints available."));
                }
                if (!lastEndpoint || synchronous) {
                    try {
                        result = this.send(session, message, endpoint);
                        if (this.exceptionPayloadAvailable(result)) continue;
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug((Object)"Successful invocation detected, stopping further processing.");
                        }
                        success = true;
                        break;
                    }
                    catch (UMOException e) {
                        this.logger.info((Object)("Failed to send to endpoint: " + endpoint.getEndpointURI().toString() + ". Error was: " + e.getMessage() + ". Trying next endpoint"));
                        continue;
                    }
                }
                try {
                    this.dispatch(session, message, endpoint);
                    success = true;
                    break;
                }
                catch (UMOException e) {
                    this.logger.info((Object)("Failed to dispatch to endpoint: " + endpoint.getEndpointURI().toString() + ". Error was: " + e.getMessage() + ". Trying next endpoint"));
                }
            }
        }
        if (!success) {
            throw new CouldNotRouteOutboundMessageException(message, endpoint);
        }
        return result;
    }

    public void addEndpoint(UMOEndpoint endpoint) {
        if (!endpoint.isRemoteSync()) {
            this.logger.debug((Object)("Endpoint: " + endpoint.getEndpointURI() + " registered on ExceptionBasedRouter needs to be RemoteSync enabled. Setting this property now."));
            endpoint.setRemoteSync(true);
        }
        super.addEndpoint(endpoint);
    }

    protected boolean exceptionPayloadAvailable(UMOMessage message) {
        if (message == null) {
            return false;
        }
        UMOExceptionPayload exceptionPayload = message.getExceptionPayload();
        if (exceptionPayload != null) {
            this.logger.info((Object)("Failure returned, will try next endpoint. Exception payload is: " + exceptionPayload));
            return true;
        }
        return false;
    }
}

