/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.response;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import edu.emory.mathcs.backport.java.util.concurrent.locks.Lock;
import edu.emory.mathcs.backport.java.util.concurrent.locks.ReentrantLock;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.config.i18n.Message;
import org.mule.routing.inbound.EventGroup;
import org.mule.routing.response.AbstractResponseRouter;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOMessage;
import org.mule.umo.routing.ResponseTimeoutException;
import org.mule.umo.routing.RoutingException;
import org.mule.util.PropertiesUtils;
import org.mule.util.concurrent.Latch;

public abstract class AbstractResponseAggregator
extends AbstractResponseRouter {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    protected Map responseEvents = new ConcurrentHashMap();
    private Map locks = new HashMap();
    protected Map eventGroups = new ConcurrentHashMap();
    private Lock locksCollectionLock = new ReentrantLock();

    public void process(UMOEvent event) throws RoutingException {
        AtomicBoolean doAggregate = new AtomicBoolean(false);
        EventGroup eg = this.addEvent(event);
        doAggregate.compareAndSet(false, this.shouldAggregate(eg));
        if (doAggregate.get()) {
            UMOMessage returnMessage = this.aggregateEvents(eg);
            Object id = eg.getGroupId();
            this.removeGroup(id);
            this.responseEvents.put(id, returnMessage);
            Lock l = null;
            this.locksCollectionLock.lock();
            l = (Lock)this.locks.get(id);
            if (l == null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Creating latch for " + id + " in " + this));
                }
                l = new Latch();
                if (this.locks.get(id) != null) {
                    throw new IllegalStateException("There is already a lock with ID: " + id);
                }
                this.locks.put(id, l);
            }
            this.locksCollectionLock.unlock();
            l.unlock();
        }
    }

    protected EventGroup addEvent(UMOEvent event) throws RoutingException {
        Object cId = this.getReplyAggregateIdentifier(event.getMessage());
        if (cId == null || cId.equals("-1")) {
            throw new RoutingException(new Message(66), event.getMessage(), event.getEndpoint());
        }
        EventGroup eg = (EventGroup)this.eventGroups.get(cId);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Adding event to response aggregator group: " + cId));
        }
        if (eg == null) {
            eg = this.createEventGroup(cId, event);
            eg.addEvent(event);
            this.eventGroups.put(eg.getGroupId(), eg);
        } else {
            eg.addEvent(event);
        }
        return eg;
    }

    protected EventGroup createEventGroup(Object id, UMOEvent event) {
        return new EventGroup(id);
    }

    protected void removeGroup(Object id) {
        this.eventGroups.remove(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UMOMessage getResponse(UMOMessage message) throws RoutingException {
        Object responseId = this.getCallResponseAggregateIdentifier(message);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Waiting for response for message id: " + responseId + " in " + this));
        }
        Lock l = null;
        this.locksCollectionLock.lock();
        l = (Lock)this.locks.get(responseId);
        if (l == null) {
            this.logger.debug((Object)("Got response but no one is waiting for it yet. Creating latch for " + responseId + " in " + this));
            l = new Latch();
            if (this.locks.get(responseId) != null) {
                throw new IllegalStateException("There is already a lock with ID: " + responseId);
            }
            this.locks.put(responseId, l);
        } else {
            this.logger.debug((Object)("Got latch for message: " + responseId));
        }
        this.locksCollectionLock.unlock();
        boolean b = false;
        try {
            this.logger.debug((Object)("Waiting for response to message: " + responseId));
            if (this.getTimeout() <= 0) {
                l.lock();
                b = true;
            } else {
                b = l.tryLock((long)this.getTimeout(), TimeUnit.MILLISECONDS);
            }
        }
        catch (InterruptedException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (!b) {
            if (this.logger.isTraceEnabled()) {
                Map e = this.responseEvents;
                synchronized (e) {
                    this.logger.trace((Object)("Current responses are: \n" + PropertiesUtils.propertiesToString(this.responseEvents, true)));
                }
            }
            throw new ResponseTimeoutException(new Message(90, String.valueOf(this.getTimeout()), responseId), message, null);
        }
        UMOMessage result = (UMOMessage)this.responseEvents.remove(responseId);
        this.locks.remove(responseId);
        if (result == null) {
            throw new IllegalStateException("Response Message is null");
        }
        return result;
    }

    protected abstract boolean shouldAggregate(EventGroup var1);

    protected abstract UMOMessage aggregateEvents(EventGroup var1) throws RoutingException;
}

