/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck;

import javax.resource.spi.work.WorkEvent;
import org.mule.MuleManager;
import org.mule.config.ConfigurationBuilder;
import org.mule.config.builders.MuleXmlConfigurationBuilder;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.umo.manager.DefaultWorkListener;

public abstract class FunctionalTestCase
extends AbstractMuleTestCase {
    protected final void doSetUp() throws Exception {
        this.doPreFunctionalSetUp();
        if (!this.getTestInfo().isDisposeManagerPerSuite()) {
            this.setupManager();
        }
        this.doPostFunctionalSetUp();
    }

    protected void suitePreSetUp() throws Exception {
        if (this.getTestInfo().isDisposeManagerPerSuite()) {
            this.setupManager();
        }
    }

    private void setupManager() throws Exception {
        MuleManager.getConfiguration().setWorkListener(new TestingWorkListener());
        ConfigurationBuilder builder = this.getBuilder();
        builder.configure(this.getConfigResources());
    }

    protected final void doTearDown() throws Exception {
        this.doFunctionalTearDown();
    }

    protected ConfigurationBuilder getBuilder() throws Exception {
        return new MuleXmlConfigurationBuilder();
    }

    protected void doPreFunctionalSetUp() throws Exception {
    }

    protected void doPostFunctionalSetUp() throws Exception {
    }

    protected void doFunctionalTearDown() throws Exception {
    }

    protected abstract String getConfigResources();

    public class TestingWorkListener
    extends DefaultWorkListener {
        protected void handleWorkException(WorkEvent event, String type) {
            Throwable t;
            super.handleWorkException(event, type);
            if (event.getException() != null && (t = event.getException().getCause()) != null) {
                if (t instanceof Error) {
                    throw (Error)t;
                }
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
            }
        }
    }
}

