/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleManager;
import org.mule.config.i18n.Message;
import org.mule.providers.NullPayload;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.transformer.TransformerException;
import org.mule.umo.transformer.UMOTransformer;
import org.mule.util.ClassUtils;
import org.mule.util.StringMessageUtils;

public abstract class AbstractTransformer
implements UMOTransformer {
    public static final String TRANSFORMER_DEFAULT = "org.mule.transformers.NoActionTransformer";
    protected transient Log logger = LogFactory.getLog(this.getClass());
    protected Class returnClass = null;
    protected String name = null;
    protected UMOImmutableEndpoint endpoint = null;
    private List sourceTypes = new ArrayList();
    protected UMOTransformer nextTransformer;
    private boolean ignoreBadInput = false;

    public AbstractTransformer() {
        this.name = this.generateTransformerName();
    }

    protected Object checkReturnClass(Object object) throws TransformerException {
        if (this.returnClass != null && !this.returnClass.isInstance(object)) {
            throw new TransformerException(new Message(53, object.getClass().getName(), (Object)this.returnClass.getName()), this);
        }
        this.logger.debug((Object)("The transformed object is of expected type. Type is: " + object.getClass().getName()));
        return object;
    }

    protected void registerSourceType(Class aClass) {
        if (aClass.equals(Object.class)) {
            this.logger.debug((Object)"java.lang.Object has been added as an acceptable sourcetype for this transformer, there will be no source type checking performed");
        }
        this.sourceTypes.add(aClass);
    }

    protected void unregisterSourceType(Class aClass) {
        this.sourceTypes.remove(aClass);
    }

    protected Iterator getSourceTypeClassesIterator() {
        return this.sourceTypes.iterator();
    }

    public String getName() {
        if (this.name == null) {
            this.setName(ClassUtils.getShortClassName(this.getClass()));
        }
        return this.name;
    }

    public void setName(String string) {
        this.logger.debug((Object)("Setting transformer name to: " + this.name));
        this.name = string;
    }

    public Class getReturnClass() {
        return this.returnClass;
    }

    public void setReturnClass(Class newClass) {
        this.returnClass = newClass;
    }

    public boolean isSourceTypeSupported(Class aClass) {
        return this.isSourceTypeSupported(aClass, false);
    }

    public boolean isSourceTypeSupported(Class aClass, boolean exactMatch) {
        if (this.sourceTypes.isEmpty()) {
            return !exactMatch;
        }
        Iterator i = this.getSourceTypeClassesIterator();
        while (i.hasNext()) {
            Class anotherClass = (Class)i.next();
            if (!(exactMatch ? anotherClass.equals(aClass) : anotherClass.isAssignableFrom(aClass))) continue;
            return true;
        }
        return false;
    }

    public final Object transform(Object src) throws TransformerException {
        Object result;
        String encoding = null;
        if (src instanceof UMOMessage && !this.isSourceTypeSupported(UMOMessage.class)) {
            encoding = ((UMOMessage)src).getEncoding();
            src = ((UMOMessage)src).getPayload();
        }
        if (!this.isSourceTypeSupported(src.getClass())) {
            if (this.ignoreBadInput) {
                this.logger.debug((Object)"Source type is incompatible with this transformer. Property 'ignoreBadInput' is set to true so the transformer chain will continue");
                return src;
            }
            throw new TransformerException(new Message(54, this.getName(), (Object)src.getClass().getName(), (Object)this.endpoint.getEndpointURI()), this);
        }
        if (this.endpoint != null && this.endpoint.getEncoding() != null) {
            encoding = this.endpoint.getEncoding();
        }
        if (encoding == null) {
            encoding = MuleManager.getConfiguration().getEncoding();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Applying transformer " + this.getName() + " (" + this.getClass().getName() + ")"));
            this.logger.debug((Object)("Object before transform: " + StringMessageUtils.truncate(src.toString(), 200, false)));
        }
        if ((result = this.doTransform(src, encoding)) == null) {
            result = new NullPayload();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Object after transform: " + StringMessageUtils.truncate(result.toString(), 200, false)));
        }
        result = this.checkReturnClass(result);
        if (this.nextTransformer != null) {
            this.logger.debug((Object)("Following transformer in the chain is " + this.nextTransformer.getName() + " (" + this.nextTransformer.getClass().getName() + ")"));
            result = this.nextTransformer.transform(result);
        }
        return result;
    }

    public UMOImmutableEndpoint getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(UMOImmutableEndpoint endpoint) {
        this.endpoint = endpoint;
        for (UMOTransformer trans = this.nextTransformer; trans != null && endpoint != null; trans = trans.getNextTransformer()) {
            trans.setEndpoint(endpoint);
        }
    }

    protected abstract Object doTransform(Object var1, String var2) throws TransformerException;

    public UMOTransformer getNextTransformer() {
        return this.nextTransformer;
    }

    public void setNextTransformer(UMOTransformer nextTransformer) {
        this.nextTransformer = nextTransformer;
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            Object c = BeanUtils.cloneBean((Object)this);
            return c;
        }
        catch (Exception e) {
            throw new CloneNotSupportedException("Failed to clone transformer: " + e.getMessage());
        }
    }

    public Class getFinalReturnClass() {
        AbstractTransformer returnTrans = this;
        for (UMOTransformer tempTrans = this; tempTrans != null; tempTrans = tempTrans.getNextTransformer()) {
            returnTrans = tempTrans;
        }
        return returnTrans.getReturnClass();
    }

    public void initialise() throws InitialisationException {
    }

    protected String generateTransformerName() {
        String name = this.getClass().getName();
        int i = name.lastIndexOf(".");
        if (i > -1) {
            name = name.substring(i + 1);
        }
        return name;
    }

    public void setSourceType(String type) throws ClassNotFoundException {
        Class clazz = ClassUtils.loadClass(type, this.getClass());
        this.registerSourceType(clazz);
    }

    public boolean isIgnoreBadInput() {
        return this.ignoreBadInput;
    }

    public void setIgnoreBadInput(boolean ignoreBadInput) {
        this.ignoreBadInput = ignoreBadInput;
    }

    public String toString() {
        return "Transformer{name='" + this.name + "'" + ", returnClass=" + this.ignoreBadInput + ", returnClass=" + this.ignoreBadInput + ", sourceTypes=" + this.sourceTypes + "}";
    }

    public boolean isAcceptNull() {
        return false;
    }
}

