/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformers.xml;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.collections.MapConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import com.thoughtworks.xstream.io.xml.XppDriver;
import com.thoughtworks.xstream.mapper.Mapper;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.mule.config.i18n.Message;
import org.mule.transformers.AbstractEventAwareTransformer;
import org.mule.umo.transformer.TransformerException;
import org.mule.util.ClassUtils;

public abstract class AbstractXStreamTransformer
extends AbstractEventAwareTransformer {
    private XStream xstream = null;
    private boolean useJaxpDom = false;
    private Map aliases;
    private List converters;

    public final XStream getXStream() throws TransformerException {
        if (this.xstream == null) {
            this.xstream = this.useJaxpDom ? new XStream((HierarchicalStreamDriver)new DomDriver()) : new XStream((HierarchicalStreamDriver)new XppDriver());
        }
        try {
            this.xstream.registerConverter((Converter)new ConcurrentHashMapConverter((Mapper)this.xstream.getClassMapper()), -1);
        }
        catch (ClassNotFoundException cnf) {
            throw new TransformerException(this, (Throwable)cnf);
        }
        this.addAliases();
        this.addConverters();
        return this.xstream;
    }

    public boolean isUseJaxpDom() {
        return this.useJaxpDom;
    }

    public void setUseJaxpDom(boolean useJaxpDom) {
        this.useJaxpDom = useJaxpDom;
    }

    private void addAliases() throws TransformerException {
        if (this.aliases == null) {
            return;
        }
        Iterator iterator = this.aliases.entrySet().iterator();
        while (iterator.hasNext()) {
            Class clazz;
            Map.Entry entry = iterator.next();
            String classname = entry.getValue().toString();
            try {
                clazz = ClassUtils.loadClass(classname, this.getClass());
            }
            catch (ClassNotFoundException e) {
                throw new TransformerException(new Message(71, classname), this, e);
            }
            this.xstream.alias(entry.getKey().toString(), clazz);
        }
    }

    private void addConverters() throws TransformerException {
        if (this.converters == null) {
            return;
        }
        Iterator iterator = this.converters.iterator();
        while (iterator.hasNext()) {
            String classname = iterator.next().toString();
            try {
                Class clazz = ClassUtils.loadClass(classname, this.getClass());
                this.xstream.registerConverter((Converter)clazz.newInstance());
            }
            catch (Exception e) {
                throw new TransformerException(this, (Throwable)e);
            }
        }
    }

    public Map getAliases() {
        return this.aliases;
    }

    public void setAliases(Map aliases) {
        this.aliases = aliases;
    }

    public List getConverters() {
        return this.converters;
    }

    public void setConverters(List converters) {
        this.converters = converters;
    }

    protected boolean requiresCurrentEvent() {
        return false;
    }

    private class ConcurrentHashMapConverter
    extends MapConverter {
        private Class jdk5ConurrentHashMap;
        private Class backportConurrentHashMap;

        public ConcurrentHashMapConverter(Mapper mapper) throws ClassNotFoundException {
            super(mapper);
            this.jdk5ConurrentHashMap = null;
            this.backportConurrentHashMap = null;
            try {
                this.jdk5ConurrentHashMap = ClassUtils.loadClass("java.util.concurrent.ConcurrentHashMap", ((Object)((Object)this)).getClass());
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            try {
                this.backportConurrentHashMap = ClassUtils.loadClass("edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap", ((Object)((Object)this)).getClass());
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (this.jdk5ConurrentHashMap == null && this.backportConurrentHashMap == null) {
                throw new ClassNotFoundException("Neither java.util.concurrent.ConcurrentHashMap nor edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap could be found - cannot continue.");
            }
        }

        public boolean canConvert(Class aClass) {
            return aClass.equals(this.backportConurrentHashMap) || aClass.equals(this.jdk5ConurrentHashMap);
        }
    }
}

