/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EnvironmentUtils {
    protected static transient Log logger = LogFactory.getLog((Class)EnvironmentUtils.class);

    private EnvironmentUtils() {
    }

    public static synchronized Properties getEnvironment() {
        Properties envProps = new Properties();
        try {
            if (SystemUtils.IS_JAVA_1_5) {
                Method envMethod = System.class.getMethod("getenv", ArrayUtils.EMPTY_CLASS_ARRAY);
                envProps.putAll((Map<?, ?>)((Map)envMethod.invoke((Object)System.class, (Object[])null)));
            } else {
                envProps = EnvironmentUtils.getEnvironmentJDK14();
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Could not access OS environment.", (Throwable)ex);
        }
        return envProps;
    }

    private static Properties getEnvironmentJDK14() throws Exception {
        Properties envProps = new Properties();
        Process process = null;
        try {
            String line;
            String command;
            boolean isUnix = true;
            if (SystemUtils.IS_OS_WINDOWS) {
                command = "cmd /c set";
                isUnix = false;
            } else {
                command = "export -p";
            }
            process = Runtime.getRuntime().exec(command);
            BufferedReader br = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = br.readLine()) != null) {
                if (line.startsWith("declare -") || line.startsWith("typeset -")) {
                    line = line.substring(11);
                }
                int index = -1;
                index = line.indexOf(61);
                if (index > -1) {
                    String key = line.substring(0, index).trim();
                    String value = line.substring(index + 1).trim();
                    if (isUnix && value.length() > 1 && (value.startsWith("\"") || value.startsWith("'"))) {
                        value = value.substring(1, value.length() - 1);
                    }
                    envProps.setProperty(key, value);
                    continue;
                }
                envProps.setProperty(line, "");
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (process != null) {
                process.destroy();
            }
        }
        return envProps;
    }
}

