/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.SystemUtils;

public class PropertiesUtils {
    private static List maskedProperties = new ArrayList();

    public static void registeredMaskedPropertyName(String name) {
        if (name != null) {
            maskedProperties.add(name);
        }
    }

    public static synchronized Properties loadProperties(String fileName) throws Exception {
        InputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(fileName));
            Properties p = new Properties();
            p.load(is);
            Properties properties = p;
            return properties;
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    public static String removeXmlNamespacePrefix(String eleName) {
        int i = eleName.indexOf(58);
        return eleName.substring(i + 1, eleName.length());
    }

    public static String removeNamespacePrefix(String eleName) {
        int i = eleName.lastIndexOf(46);
        return eleName.substring(i + 1, eleName.length());
    }

    public static Map removeNamespaces(Map properties) {
        HashMap props = new HashMap(properties.size());
        Iterator iter = properties.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            props.put(PropertiesUtils.removeNamespacePrefix((String)entry.getKey()), entry.getValue());
        }
        return props;
    }

    public static Map getPropertiesWithPrefix(Map props, String prefix) {
        HashMap newProps = new HashMap();
        Iterator iterator = props.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (!entry.getKey().toString().startsWith(prefix)) continue;
            newProps.put(entry.getKey(), entry.getValue());
        }
        return newProps;
    }

    public static void getPropertiesWithPrefix(Map props, String prefix, Map newProps) {
        Iterator iterator = props.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (!entry.getKey().toString().startsWith(prefix)) continue;
            newProps.put(entry.getKey(), entry.getValue());
        }
    }

    public static Map getPropertiesWithoutPrefix(Map props, String prefix) {
        HashMap newProps = new HashMap();
        Iterator iterator = props.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (entry.getKey().toString().startsWith(prefix)) continue;
            newProps.put(entry.getKey(), entry.getValue());
        }
        return newProps;
    }

    public static Properties getPropertiesFromQueryString(String query) {
        Properties props = new Properties();
        if (query == null) {
            return props;
        }
        query = new StringBuffer(query.length() + 1).append('&').append(query).toString();
        int x = 0;
        while ((x = PropertiesUtils.addProperty(query, x, props)) != -1) {
        }
        return props;
    }

    private static int addProperty(String query, int start, Properties properties) {
        String pair;
        int i = query.indexOf(38, start);
        int i2 = query.indexOf(38, i + 1);
        if (i > -1 && i2 > -1) {
            pair = query.substring(i + 1, i2);
        } else if (i > -1) {
            pair = query.substring(i + 1);
        } else {
            return -1;
        }
        int eq = pair.indexOf(61);
        if (eq <= 0) {
            String key = pair;
            String value = "";
            properties.setProperty(key, value);
        } else {
            String key = pair.substring(0, eq);
            String value = eq == pair.length() ? "" : pair.substring(eq + 1);
            properties.setProperty(key, value);
        }
        return i2;
    }

    public static String propertiesToString(Map props, boolean newline) {
        int i;
        if (props == null || props.isEmpty()) {
            return "{}";
        }
        StringBuffer buf = new StringBuffer(props.size() * 32);
        buf.append('{');
        if (newline) {
            buf.append(SystemUtils.LINE_SEPARATOR);
        }
        Object[] entries = props.entrySet().toArray();
        int numEntries = entries.length;
        for (i = 0; i < numEntries - 1; ++i) {
            PropertiesUtils.appendMaskedProperty(buf, (Map.Entry)entries[i]);
            if (newline) {
                buf.append(SystemUtils.LINE_SEPARATOR);
                continue;
            }
            buf.append(',').append(' ');
        }
        PropertiesUtils.appendMaskedProperty(buf, (Map.Entry)entries[i]);
        if (newline) {
            buf.append(SystemUtils.LINE_SEPARATOR);
        }
        buf.append('}');
        return buf.toString();
    }

    private static void appendMaskedProperty(StringBuffer buffer, Map.Entry property) {
        String key = property.getKey().toString();
        buffer.append(key).append('=');
        if (maskedProperties.contains(key)) {
            buffer.append("*****");
        } else {
            buffer.append(property.getValue());
        }
    }

    static {
        PropertiesUtils.registeredMaskedPropertyName("password");
    }
}

