/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import org.apache.commons.io.IOUtils;
import org.mule.util.file.DeleteException;
import org.mule.util.file.FileSession;
import org.mule.util.xa.AbstractXAResourceManager;
import org.mule.util.xa.DefaultXASession;

public class TransactedFileSession
extends DefaultXASession
implements FileSession {
    public TransactedFileSession(AbstractXAResourceManager resourceManager) {
        super(resourceManager);
    }

    public FileInputStream openInputStream(File f) throws IOException {
        if (this.localContext != null) {
            return null;
        }
        return new FileInputStream(f);
    }

    public FileOutputStream openOutputStream(File f, boolean append) throws IOException {
        if (this.localContext != null) {
            return null;
        }
        return new FileOutputStream(f, append);
    }

    public FileOutputStream openOutputStream(File f) throws IOException {
        return this.openOutputStream(f, false);
    }

    public boolean mkdir(File f) throws IOException {
        if (this.localContext != null) {
            return false;
        }
        return f.mkdir();
    }

    public RandomAccessFile openRandomAccess(File f, String mode) throws IOException {
        if (this.localContext != null) {
            return null;
        }
        return new RandomAccessFile(f, mode);
    }

    public void delete(File f) throws IOException {
        if (this.localContext == null && !f.delete()) {
            throw new DeleteException(f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copy(File source, File dest) throws IOException {
        if (dest.exists()) {
            this.delete(dest);
        }
        FileInputStream is = null;
        FileOutputStream os = null;
        try {
            is = this.openInputStream(source);
            try {
                os = this.openOutputStream(dest);
                IOUtils.copy((InputStream)is, (OutputStream)os);
            }
            finally {
                IOUtils.closeQuietly((OutputStream)os);
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    public void rename(File source, File dest) throws IOException {
        this.copy(source, dest);
        this.delete(dest);
    }
}

