/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.queue;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.util.queue.MemoryPersistenceStrategy;
import org.mule.util.queue.QueueConfiguration;
import org.mule.util.queue.QueueInfo;
import org.mule.util.queue.QueueManager;
import org.mule.util.queue.QueuePersistenceStrategy;
import org.mule.util.queue.QueueSession;
import org.mule.util.queue.TransactionalQueueSession;
import org.mule.util.xa.AbstractTransactionContext;
import org.mule.util.xa.AbstractXAResourceManager;
import org.mule.util.xa.ResourceManagerException;
import org.mule.util.xa.ResourceManagerSystemException;

public class TransactionalQueueManager
extends AbstractXAResourceManager
implements QueueManager {
    private static Log logger = LogFactory.getLog((Class)TransactionalQueueManager.class);
    private Map queues = new HashMap();
    private QueuePersistenceStrategy memoryPersistenceStrategy = new MemoryPersistenceStrategy();
    private QueuePersistenceStrategy persistenceStrategy;
    private QueueConfiguration defaultQueueConfiguration = new QueueConfiguration(false);

    public synchronized QueueSession getQueueSession() {
        return new TransactionalQueueSession(this, this);
    }

    public synchronized void setDefaultQueueConfiguration(QueueConfiguration config) {
        this.defaultQueueConfiguration = config;
    }

    public synchronized void setQueueConfiguration(String queueName, QueueConfiguration config) {
        this.getQueue((String)queueName).config = config;
    }

    protected synchronized QueueInfo getQueue(String name) {
        QueueInfo q = (QueueInfo)this.queues.get(name);
        if (q == null) {
            q = new QueueInfo();
            q.name = name;
            q.list = new LinkedList();
            q.config = this.defaultQueueConfiguration;
            this.queues.put(name, q);
        }
        return q;
    }

    protected Log getLogger() {
        return logger;
    }

    public void close() {
        try {
            this.stop(0);
        }
        catch (ResourceManagerException e) {
            logger.error((Object)"Error disposing manager", (Throwable)e);
        }
    }

    protected void doStart() throws ResourceManagerSystemException {
        if (this.persistenceStrategy != null) {
            try {
                this.persistenceStrategy.open();
            }
            catch (IOException e) {
                throw new ResourceManagerSystemException(e);
            }
        }
    }

    protected boolean shutdown(int mode, long timeoutMSecs) {
        try {
            if (this.persistenceStrategy != null) {
                this.persistenceStrategy.close();
            }
        }
        catch (IOException e) {
            logger.error((Object)"Error closing persistent store", (Throwable)e);
        }
        return super.shutdown(mode, timeoutMSecs);
    }

    protected void recover() throws ResourceManagerSystemException {
        if (this.persistenceStrategy != null) {
            try {
                List msgs = this.persistenceStrategy.restore();
                Iterator it = msgs.iterator();
                while (it.hasNext()) {
                    QueuePersistenceStrategy.Holder h = (QueuePersistenceStrategy.Holder)it.next();
                    this.getQueue(h.getQueue()).putNow(h.getId());
                }
            }
            catch (Exception e) {
                throw new ResourceManagerSystemException(e);
            }
        }
    }

    protected AbstractTransactionContext createTransactionContext(Object session) {
        return new QueueTransactionContext();
    }

    protected void doBegin(AbstractTransactionContext context) {
    }

    protected int doPrepare(AbstractTransactionContext context) {
        return 0;
    }

    protected void doCommit(AbstractTransactionContext context) throws ResourceManagerException {
        QueueTransactionContext ctx = (QueueTransactionContext)context;
        try {
            QueueInfo queue;
            Map.Entry entry;
            Iterator it;
            if (ctx.added != null) {
                it = ctx.added.entrySet().iterator();
                while (it.hasNext()) {
                    entry = it.next();
                    queue = (QueueInfo)entry.getKey();
                    List queueAdded = (List)entry.getValue();
                    if (queueAdded == null || queueAdded.size() <= 0) continue;
                    Iterator itAdded = queueAdded.iterator();
                    while (itAdded.hasNext()) {
                        Object object = itAdded.next();
                        Object id = this.doStore(queue, object);
                        queue.putNow(id);
                    }
                }
            }
            if (ctx.removed != null) {
                it = ctx.removed.entrySet().iterator();
                while (it.hasNext()) {
                    entry = it.next();
                    queue = (QueueInfo)entry.getKey();
                    List queueRemoved = (List)entry.getValue();
                    if (queueRemoved == null || queueRemoved.size() <= 0) continue;
                    Iterator itRemoved = queueRemoved.iterator();
                    while (itRemoved.hasNext()) {
                        Object id = itRemoved.next();
                        this.doRemove(queue, id);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new ResourceManagerException(e);
        }
        finally {
            ctx.added = null;
            ctx.removed = null;
        }
    }

    protected Object doStore(QueueInfo queue, Object object) throws IOException {
        QueuePersistenceStrategy ps = queue.config.persistent ? this.persistenceStrategy : this.memoryPersistenceStrategy;
        Object id = ps.store(queue.name, object);
        return id;
    }

    protected void doRemove(QueueInfo queue, Object id) throws IOException {
        QueuePersistenceStrategy ps = queue.config.persistent ? this.persistenceStrategy : this.memoryPersistenceStrategy;
        ps.remove(queue.name, id);
    }

    protected Object doLoad(QueueInfo queue, Object id) throws IOException {
        QueuePersistenceStrategy ps = queue.config.persistent ? this.persistenceStrategy : this.memoryPersistenceStrategy;
        Object obj = ps.load(queue.name, id);
        return obj;
    }

    protected void doRollback(AbstractTransactionContext context) throws ResourceManagerException {
        QueueTransactionContext ctx = (QueueTransactionContext)context;
        if (ctx.removed != null) {
            Iterator it = ctx.removed.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                QueueInfo queue = (QueueInfo)entry.getKey();
                List queueRemoved = (List)entry.getValue();
                if (queueRemoved == null || queueRemoved.size() <= 0) continue;
                Iterator itRemoved = queueRemoved.iterator();
                while (itRemoved.hasNext()) {
                    Object id = itRemoved.next();
                    queue.putNow(id);
                }
            }
        }
        ctx.added = null;
        ctx.removed = null;
    }

    public QueuePersistenceStrategy getPersistenceStrategy() {
        return this.persistenceStrategy;
    }

    public void setPersistenceStrategy(QueuePersistenceStrategy persistenceStrategy) {
        if (this.operationMode != 0) {
            throw new IllegalStateException();
        }
        this.persistenceStrategy = persistenceStrategy;
    }

    public QueuePersistenceStrategy getMemoryPersistenceStrategy() {
        return this.memoryPersistenceStrategy;
    }

    public void setMemoryPersistenceStrategy(QueuePersistenceStrategy memoryPersistenceStrategy) {
        if (this.operationMode != 0) {
            throw new IllegalStateException();
        }
        this.memoryPersistenceStrategy = memoryPersistenceStrategy;
    }

    protected class QueueTransactionContext
    extends AbstractTransactionContext {
        protected Map added;
        protected Map removed;

        protected QueueTransactionContext() {
        }

        public boolean offer(QueueInfo queue, Object item, long timeout) throws InterruptedException {
            ArrayList<Object> queueAdded;
            this.readOnly = false;
            if (this.added == null) {
                this.added = new HashMap();
            }
            if ((queueAdded = (ArrayList<Object>)this.added.get(queue)) == null) {
                queueAdded = new ArrayList<Object>();
                this.added.put(queue, queueAdded);
            }
            if (queue.offer(null, queueAdded.size(), Long.MAX_VALUE)) {
                queueAdded.add(item);
                return true;
            }
            return false;
        }

        public Object poll(QueueInfo queue, long timeout) throws IOException, InterruptedException {
            List queueAdded;
            this.readOnly = false;
            if (this.added != null && (queueAdded = (List)this.added.get(queue)) != null) {
                return queueAdded.remove(queueAdded.size() - 1);
            }
            Object o = queue.poll(Long.MAX_VALUE);
            if (o != null) {
                ArrayList<Object> queueRemoved;
                if (this.removed == null) {
                    this.removed = new HashMap();
                }
                if ((queueRemoved = (ArrayList<Object>)this.removed.get(queue)) == null) {
                    queueRemoved = new ArrayList<Object>();
                    this.removed.put(queue, queueRemoved);
                }
                queueRemoved.add(o);
                o = TransactionalQueueManager.this.doLoad(queue, o);
            }
            return o;
        }

        public Object peek(QueueInfo queue) throws IOException, InterruptedException {
            List queueAdded;
            this.readOnly = false;
            if (this.added != null && (queueAdded = (List)this.added.get(queue)) != null) {
                return queueAdded.get(queueAdded.size() - 1);
            }
            Object o = queue.peek();
            if (o != null) {
                o = TransactionalQueueManager.this.doLoad(queue, o);
            }
            return o;
        }

        public int size(QueueInfo queue) {
            List queueAdded;
            int sz = queue.list.size();
            if (this.added != null && (queueAdded = (List)this.added.get(queue)) != null) {
                sz += queueAdded.size();
            }
            return sz;
        }
    }
}

