/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.dq;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.DataQueue;
import com.ibm.as400.access.DataQueueEntry;
import com.ibm.as400.access.Record;
import com.ibm.as400.access.RecordFormat;
import org.mule.impl.MuleMessage;
import org.mule.providers.AbstractConnector;
import org.mule.providers.AbstractMessageDispatcher;
import org.mule.providers.dq.DQConnector;
import org.mule.providers.dq.DQMessage;
import org.mule.providers.dq.DQMessageUtils;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOEndpointURI;

public class DQMessageDispatcher
extends AbstractMessageDispatcher {
    private DQConnector connector;

    public DQMessageDispatcher(DQConnector connector) {
        super((AbstractConnector)connector);
        this.connector = connector;
    }

    public void doDispatch(UMOEvent event) throws Exception {
        try {
            DQMessage msg = (DQMessage)event.getMessage().getPayload();
            AS400 system = this.connector.getSystem();
            RecordFormat format = this.getRecordFormat(event.getEndpoint().getEndpointURI());
            Record rec = DQMessageUtils.getRecord(msg, format);
            DataQueue dq = new DataQueue(system, event.getEndpoint().getEndpointURI().getAddress());
            dq.write(rec.getContents());
        }
        catch (Exception e) {
            this.getConnector().handleException(e);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"doDispatch(UMOEvent) - end");
        }
    }

    protected RecordFormat getRecordFormat(UMOEndpointURI endpointUri) throws Exception {
        String recordDescriptor = (String)endpointUri.getParams().get("recordDescriptor");
        if (recordDescriptor == null) {
            if (this.connector.getFormat() == null) {
                throw new IllegalArgumentException("Property recordDescriptor must be set on the endpoint");
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Defaulting to connector format: " + this.connector.getRecordFormat()));
            }
            return this.connector.getFormat();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Using endpoint-specific format: " + this.connector.getRecordFormat()));
        }
        return DQMessageUtils.getRecordFormat(recordDescriptor, this.connector.getSystem());
    }

    public UMOMessage doSend(UMOEvent event) throws Exception {
        this.doDispatch(event);
        return null;
    }

    public Object getDelegateSession() throws UMOException {
        return null;
    }

    public UMOMessage receive(UMOEndpointURI endpointUri, long timeout) throws Exception {
        DataQueueEntry entry;
        DataQueue dq = new DataQueue(this.connector.getSystem(), endpointUri.getAddress());
        if (dq != null && (entry = dq.read((int)timeout)) != null) {
            RecordFormat format = this.getRecordFormat(endpointUri);
            DQMessage message = DQMessageUtils.getDQMessage(entry.getData(), format);
            message.setSenderInformation(entry.getSenderInformation());
            return new MuleMessage(this.connector.getMessageAdapter(message));
        }
        return null;
    }

    public void doDispose() {
    }
}

