/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.dq;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.DataQueue;
import com.ibm.as400.access.DataQueueEntry;
import com.ibm.as400.access.RecordFormat;
import org.mule.config.i18n.Message;
import org.mule.impl.MuleMessage;
import org.mule.providers.PollingMessageReceiver;
import org.mule.providers.dq.DQConnector;
import org.mule.providers.dq.DQMessage;
import org.mule.providers.dq.DQMessageUtils;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.provider.UMOConnector;

public class DQMessageReceiver
extends PollingMessageReceiver {
    private DataQueue dataQueue = null;
    private RecordFormat format = null;

    public DQMessageReceiver(UMOConnector connector, UMOComponent component, UMOEndpoint endpoint, Long frequency, DataQueue pDq, AS400 pAs400) throws InitialisationException {
        super(connector, component, endpoint, frequency);
        this.dataQueue = pDq;
        String recordDescriptor = (String)endpoint.getEndpointURI().getParams().get("recordDescriptor");
        if (recordDescriptor == null) {
            this.format = ((DQConnector)connector).getFormat();
            if (this.format == null) {
                throw new InitialisationException(new Message("dq", 1), (Object)this);
            }
        } else {
            try {
                this.format = DQMessageUtils.getRecordFormat(recordDescriptor, pAs400);
            }
            catch (Exception e) {
                throw new InitialisationException(new Message(58, (Object)("recordDescriptor: " + recordDescriptor)), (Throwable)e, (Object)this);
            }
        }
    }

    public final void poll() {
        try {
            DataQueueEntry entry = this.dataQueue.read();
            if (entry == null) {
                return;
            }
            this.processEntry(entry);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private void processEntry(DataQueueEntry entry) throws Exception {
        DQMessage message = DQMessageUtils.getDQMessage(entry.getData(), this.format);
        message.setSenderInformation(entry.getSenderInformation());
        MuleMessage umoMessage = new MuleMessage(this.connector.getMessageAdapter((Object)message));
        this.routeMessage((UMOMessage)umoMessage);
    }

    public void doConnect() throws Exception {
    }

    public void doDisconnect() throws Exception {
    }
}

