/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.dq;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.DataQueue;
import com.ibm.as400.access.RecordFormat;
import java.util.Map;
import org.mule.config.i18n.Message;
import org.mule.providers.AbstractServiceEnabledConnector;
import org.mule.providers.dq.DQMessageUtils;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOException;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.provider.UMOMessageReceiver;

public class DQConnector
extends AbstractServiceEnabledConnector {
    public static final String LIB_PROPERTY = "lib";
    public static final String RECORD_DESCRIPTOR_PROPERTY = "recordDescriptor";
    private static final long DEFAULT_POLLING = 1000L;
    public static final String PROPERTY_POLLING_FREQUENCY = "pollingFrequency";
    private Long pollingFrequency = new Long(1000L);
    private String hostname;
    private String username;
    private String password;
    private String recordFormat = null;
    private RecordFormat format;
    private AS400 as400System = null;

    public UMOMessageReceiver createReceiver(UMOComponent component, UMOEndpoint endpoint) throws Exception {
        String tempPolling;
        Map props = endpoint.getProperties();
        if (props != null && (tempPolling = (String)props.get(PROPERTY_POLLING_FREQUENCY)) != null) {
            this.pollingFrequency = new Long(tempPolling);
        }
        if (this.pollingFrequency <= 0L) {
            this.pollingFrequency = new Long(1000L);
        }
        this.logger.debug((Object)("set polling frequency to: " + this.pollingFrequency));
        String lib = (String)endpoint.getEndpointURI().getParams().get(LIB_PROPERTY);
        this.logger.debug((Object)("provider endpoint: " + endpoint.getName() + " - lib: " + lib));
        String name = "";
        if (lib != null) {
            name = lib + "/";
        }
        name = name + endpoint.getEndpointURI().getAddress();
        DataQueue dq = new DataQueue(this.as400System, name);
        return this.serviceDescriptor.createMessageReceiver((UMOConnector)this, component, endpoint, new Object[]{this.pollingFrequency, dq, this.as400System});
    }

    public final String getPassword() {
        return this.password;
    }

    public void setPassword(String pPassword) {
        this.password = pPassword;
    }

    public Long getPollingFrequency() {
        return this.pollingFrequency;
    }

    public void setPollingFrequency(Long pPollingFrequency) {
        this.pollingFrequency = pPollingFrequency;
    }

    public AS400 getSystem() {
        return this.as400System;
    }

    public void setSystem(AS400 pSystem) {
        this.as400System = pSystem;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String pSystemName) {
        this.hostname = pSystemName;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void doInitialise() throws InitialisationException {
        super.doInitialise();
        this.as400System = new AS400(this.hostname, this.username, this.password);
        if (this.recordFormat != null) {
            try {
                this.format = DQMessageUtils.getRecordFormat(this.recordFormat, this.as400System);
            }
            catch (Exception e) {
                throw new InitialisationException(new Message(58, (Object)("Record Format: " + this.recordFormat)), (Throwable)e, (Object)this);
            }
        }
    }

    public final String getProtocol() {
        return "dq";
    }

    protected void doStop() throws UMOException {
        this.as400System.disconnectAllServices();
    }

    public String getRecordFormat() {
        return this.recordFormat;
    }

    public void setRecordFormat(String recordFormat) {
        this.recordFormat = recordFormat;
    }

    public RecordFormat getFormat() {
        return this.format;
    }

    public void setFormat(RecordFormat format) {
        this.format = format;
    }
}

