/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.dq;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.CharacterFieldDescription;
import com.ibm.as400.access.FieldDescription;
import com.ibm.as400.access.Record;
import com.ibm.as400.access.RecordFormat;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.mule.providers.dq.DQMessage;

public final class DQMessageUtils {
    private static final Logger LOGGER = Logger.getLogger((Class)(class$org$mule$providers$dq$DQMessageUtils == null ? (class$org$mule$providers$dq$DQMessageUtils = DQMessageUtils.class$("org.mule.providers.dq.DQMessageUtils")) : class$org$mule$providers$dq$DQMessageUtils));
    public static final String RECORD_DESCRIPTOR_KEY = "recordDescriptor";
    static /* synthetic */ Class class$org$mule$providers$dq$DQMessageUtils;

    private DQMessageUtils() {
    }

    public static synchronized DQMessage getDQMessage(byte[] data, RecordFormat format) throws Exception {
        Record record = format.getNewRecord(data);
        DQMessage message = new DQMessage();
        String[] names = format.getFieldNames();
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            message.addEntry(name, record.getField(name));
        }
        return message;
    }

    public static synchronized Record getRecord(DQMessage msg, RecordFormat format) {
        Record rec = format.getNewRecord();
        String[] tab = format.getFieldNames();
        for (int i = 0; i < tab.length; ++i) {
            String name = tab[i];
            Object field = msg.getEntry(name);
            if (field == null) {
                field = "";
            }
            rec.setField(name, field);
        }
        return rec;
    }

    public static synchronized RecordFormat getRecordFormat(String recordDescriptor, AS400 as400) throws Exception {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Record descriptor :" + recordDescriptor));
        }
        if (recordDescriptor == null) {
            throw new Exception("Failed to read record descriptor : recordDescriptor property is not set ");
        }
        InputStream input = null;
        RecordFormat recordFormat = null;
        try {
            File file = new File(recordDescriptor);
            if (file.exists()) {
                input = new FileInputStream(file);
            } else {
                input = (class$org$mule$providers$dq$DQMessageUtils == null ? (class$org$mule$providers$dq$DQMessageUtils = DQMessageUtils.class$("org.mule.providers.dq.DQMessageUtils")) : class$org$mule$providers$dq$DQMessageUtils).getClassLoader().getResourceAsStream(recordDescriptor);
                if (input == null) {
                    throw new Exception("Failed to read record descriptor  (" + recordDescriptor + ") cannot be found ");
                }
            }
            recordFormat = DQMessageUtils.parse(input, as400);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (input != null) {
                input.close();
            }
        }
        return recordFormat;
    }

    private static RecordFormat parse(InputStream stream, AS400 as400) throws Exception {
        SAXReader reader = new SAXReader();
        Document document = reader.read(stream);
        RecordFormat rec = new RecordFormat();
        Element root = document.getRootElement();
        Iterator i = root.elementIterator();
        while (i.hasNext()) {
            Element element = (Element)i.next();
            String name = element.attributeValue("name");
            int length = Integer.decode(element.attributeValue("length"));
            DQMessageUtils.addCharacterField(rec, length, name, as400);
        }
        return rec;
    }

    private static void addCharacterField(RecordFormat format, int length, String name, AS400 as400) {
        format.addFieldDescription((FieldDescription)new CharacterFieldDescription(new AS400Text(length, as400), name));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

