/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extras.spring.events;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.InitialisationException;
import org.mule.MuleManager;
import org.mule.MuleRuntimeException;
import org.mule.config.builders.QuickConfigurationBuilder;
import org.mule.extras.spring.SpringContainerContext;
import org.mule.extras.spring.events.ApplicationEventException;
import org.mule.extras.spring.events.AsynchronousEventListener;
import org.mule.extras.spring.events.MuleApplicationEvent;
import org.mule.extras.spring.events.MuleEventListener;
import org.mule.extras.spring.events.MuleSubscriptionEventListener;
import org.mule.impl.ImmutableMuleEndpoint;
import org.mule.impl.MuleDescriptor;
import org.mule.impl.MuleEvent;
import org.mule.impl.MuleMessage;
import org.mule.impl.RequestContext;
import org.mule.impl.endpoint.MuleEndpoint;
import org.mule.impl.endpoint.MuleEndpointURI;
import org.mule.routing.filters.WildcardFilter;
import org.mule.umo.UMODescriptor;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOEventContext;
import org.mule.umo.UMOException;
import org.mule.umo.UMOFilter;
import org.mule.umo.UMOManager;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.MalformedEndpointException;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.model.UMOContainerContext;
import org.mule.umo.model.UMOModel;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.provider.UMOMessageDispatcher;
import org.mule.umo.routing.UMOInboundMessageRouter;
import org.mule.umo.transformer.TransformerException;
import org.mule.umo.transformer.UMOTransformer;
import org.mule.util.ClassHelper;
import org.mule.util.PropertiesHelper;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ApplicationEventMulticaster;
import org.springframework.context.event.ContextRefreshedEvent;

public class MuleEventMulticaster
implements ApplicationEventMulticaster,
ApplicationContextAware {
    public static final String EVENT_MULTICASTER_DESCRIPTOR_NAME = "muleEventMulticasterDescriptor";
    protected static transient Log logger = LogFactory.getLog((Class)(class$org$mule$extras$spring$events$MuleEventMulticaster == null ? (class$org$mule$extras$spring$events$MuleEventMulticaster = MuleEventMulticaster.class$("org.mule.extras.spring.events.MuleEventMulticaster")) : class$org$mule$extras$spring$events$MuleEventMulticaster));
    private Set listeners = new HashSet();
    private boolean asynchronous = false;
    private Map endpointMappings = null;
    private String[] subscriptions = null;
    private ApplicationContext applicationContext;
    private UMODescriptor descriptor;
    private UMOEventContext muleEventContext;
    private Class subscriptionFilter = class$org$mule$routing$filters$WildcardFilter == null ? (class$org$mule$routing$filters$WildcardFilter = MuleEventMulticaster.class$("org.mule.routing.filters.WildcardFilter")) : class$org$mule$routing$filters$WildcardFilter;
    private Map endpointsCache = new HashMap();
    static /* synthetic */ Class class$org$mule$extras$spring$events$MuleEventMulticaster;
    static /* synthetic */ Class class$org$mule$routing$filters$WildcardFilter;
    static /* synthetic */ Class class$org$mule$umo$provider$UMOConnector;
    static /* synthetic */ Class class$org$mule$umo$transformer$UMOTransformer;

    public void addApplicationListener(ApplicationListener listener) {
        if (this.asynchronous) {
            AsynchronousEventListener aListener = new AsynchronousEventListener(((MuleDescriptor)this.descriptor).getThreadingProfile().createPool("spring-events"), listener);
            this.listeners.add(aListener);
        } else {
            this.listeners.add(listener);
        }
    }

    public void removeApplicationListener(ApplicationListener listener) {
        this.listeners.remove(listener);
    }

    public void removeAllListeners() {
        this.listeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void multicastEvent(ApplicationEvent e) {
        MuleApplicationEvent muleEvent = null;
        if (e instanceof ContextRefreshedEvent) {
            if (MuleManager.isInstanciated() && !MuleManager.getInstance().isInitialised()) {
                try {
                    this.registerMulticasterDescriptor();
                }
                catch (UMOException ex) {
                    throw new MuleRuntimeException("Failed to reinitialise Mule after the context was refreshed: " + ex.getMessage(), (Throwable)ex);
                }
            } else {
                this.initMule();
            }
        }
        if (e instanceof MuleApplicationEvent && (muleEvent = (MuleApplicationEvent)e).getMuleEventContext() == null) {
            try {
                this.dispatchEvent(RequestContext.getEventContext(), muleEvent);
            }
            catch (ApplicationEventException e1) {
                logger.error((Object)("failed to dispatch event: " + e.toString()), (Throwable)e1);
            }
            return;
        }
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ApplicationListener listener = (ApplicationListener)iterator.next();
            if (muleEvent != null) {
                if (listener instanceof MuleSubscriptionEventListener) {
                    if (!this.isSubscriptionMatch(muleEvent.getEndpoint().getAddress(), ((MuleSubscriptionEventListener)listener).getSubscriptions())) continue;
                    listener.onApplicationEvent((ApplicationEvent)muleEvent);
                    continue;
                }
                if (!(listener instanceof MuleEventListener)) continue;
                listener.onApplicationEvent((ApplicationEvent)muleEvent);
                continue;
            }
            if (listener instanceof MuleEventListener) continue;
            listener.onApplicationEvent(e);
        }
    }

    private boolean isSubscriptionMatch(String endpoint, String[] subscriptions) {
        UMOFilter filter = null;
        for (int i = 0; i < subscriptions.length; ++i) {
            String subscription = PropertiesHelper.getStringProperty((Map)MuleManager.getInstance().getEndpointIdentifiers(), (Object)subscriptions[i], (String)subscriptions[i]);
            if (MuleEndpointURI.isMuleUri((String)subscription)) {
                UMOEndpointURI ep = (UMOEndpointURI)this.endpointsCache.get(subscription);
                if (ep == null) {
                    try {
                        ep = new MuleEndpointURI(subscription);
                    }
                    catch (MalformedEndpointException e) {
                        throw new IllegalArgumentException(e.getMessage());
                    }
                    this.endpointsCache.put(subscription, ep);
                }
                subscription = ep.getAddress();
            }
            if (!(filter = this.createFilter(subscription)).accept((Object)endpoint)) continue;
            return true;
        }
        return false;
    }

    public boolean isAsynchronous() {
        return this.asynchronous;
    }

    public void setAsynchronous(boolean asynchronous) {
        this.asynchronous = asynchronous;
    }

    public void onMuleEvent(UMOEventContext context) throws TransformerException, MalformedEndpointException {
        this.muleEventContext = context;
        this.multicastEvent(new MuleApplicationEvent(context.getTransformedMessage(), context, this.applicationContext));
        context.setStopFurtherProcessing(true);
    }

    protected void dispatchEvent(UMOEventContext eventContext, MuleApplicationEvent applicationEvent) throws ApplicationEventException {
        UMOEndpoint endpoint = null;
        try {
            endpoint = ImmutableMuleEndpoint.getOrCreateEndpointForUri((UMOEndpointURI)applicationEvent.getEndpoint(), (String)"sender");
        }
        catch (UMOException e) {
            throw new ApplicationEventException("Failed to get endpoint for endpointUri: " + applicationEvent.getEndpoint(), e);
        }
        if (endpoint != null) {
            try {
                if (applicationEvent.getEndpoint() != null) {
                    endpoint.setEndpointURI(applicationEvent.getEndpoint());
                }
                MuleMessage message = new MuleMessage(((EventObject)((Object)applicationEvent)).getSource(), applicationEvent.getProperties());
                if (RequestContext.getEvent() != null) {
                    eventContext.setStopFurtherProcessing(true);
                    eventContext.dispatchEvent((UMOMessage)message, endpoint);
                }
                if (endpoint.getTransformer() != null) {
                    message = new MuleMessage(endpoint.getTransformer().transform(((EventObject)((Object)applicationEvent)).getSource()), applicationEvent.getProperties());
                }
                UMOMessageDispatcher dispatcher = endpoint.getConnector().getDispatcher(endpoint.getEndpointURI().getAddress());
                dispatcher.dispatch((UMOEvent)new MuleEvent((UMOMessage)message, endpoint, null, false));
            }
            catch (Exception e1) {
                throw new ApplicationEventException("Failed to dispatch event: " + e1.getMessage(), e1);
            }
        } else {
            throw new ApplicationEventException("Failed endpoint using name: " + applicationEvent.getEndpoint());
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    protected void initMule() {
        try {
            this.endpointsCache.clear();
            if (this.applicationContext.containsBean(EVENT_MULTICASTER_DESCRIPTOR_NAME)) {
                this.descriptor = (UMODescriptor)this.applicationContext.getBean(EVENT_MULTICASTER_DESCRIPTOR_NAME);
            }
            if (this.applicationContext.containsBean("muleManager")) {
                return;
            }
            UMOManager manager = MuleManager.getInstance();
            if (!manager.isStarted()) {
                MuleManager.getConfiguration().setSynchronous(!this.asynchronous);
                this.registerEndpointMappings();
            }
            SpringContainerContext containerContext = new SpringContainerContext();
            containerContext.setBeanFactory((BeanFactory)this.applicationContext);
            manager.setContainerContext((UMOContainerContext)containerContext);
            this.registerConnectors();
            this.registerTransformers();
            this.registerMulticasterDescriptor();
            if (!manager.isStarted()) {
                manager.start();
            }
        }
        catch (UMOException e) {
            throw new MuleRuntimeException("Failed to reinitialise Mule after the context was refreshed: " + e.getMessage(), (Throwable)e);
        }
    }

    protected void registerMulticasterDescriptor() throws UMOException {
        if (this.descriptor == null) {
            this.descriptor = this.getDefaultDescriptor();
            this.setSubscriptionsOnDescriptor((MuleDescriptor)this.descriptor);
            MuleManager.getInstance().getModel().registerComponent(this.descriptor);
        }
    }

    protected void setSubscriptionsOnDescriptor(MuleDescriptor descriptor) throws UMOException {
        ArrayList<String> endpoints = new ArrayList<String>();
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ApplicationListener listener = (ApplicationListener)iterator.next();
            if (!(listener instanceof MuleSubscriptionEventListener)) continue;
            String[] subscriptions = ((MuleSubscriptionEventListener)listener).getSubscriptions();
            for (int i = 0; i < subscriptions.length; ++i) {
                boolean isSoap;
                if (subscriptions[i].indexOf("*") != -1 || !MuleEndpointURI.isMuleUri((String)subscriptions[i]) || (isSoap = this.registerAsSoap(subscriptions[i], listener))) continue;
                endpoints.add(subscriptions[i]);
            }
        }
        if (endpoints.size() > 0) {
            Iterator iterator2 = endpoints.iterator();
            while (iterator2.hasNext()) {
                String endpoint = (String)iterator2.next();
                descriptor.getInboundRouter().addEndpoint((UMOEndpoint)new MuleEndpoint(endpoint, true));
            }
        }
    }

    private boolean registerAsSoap(String endpoint, Object listener) throws UMOException {
        if (endpoint.startsWith("glue") || endpoint.startsWith("soap") || endpoint.startsWith("axis")) {
            int i;
            MuleEndpointURI ep = new MuleEndpointURI(endpoint);
            QuickConfigurationBuilder builder = new QuickConfigurationBuilder();
            String serviceName = null;
            if (ep.getPath() != null) {
                String path = ep.getPath();
                if (path.endsWith("/")) {
                    path = path.substring(0, path.length() - 1);
                }
                if ((i = path.lastIndexOf("/")) > -1) {
                    serviceName = path.substring(i + 1);
                }
            } else {
                serviceName = this.descriptor.getName();
            }
            String newEndpoint = endpoint;
            i = newEndpoint.indexOf(serviceName);
            newEndpoint = newEndpoint.substring(0, i - 1);
            builder.registerComponentInstance(listener, serviceName, (UMOEndpointURI)new MuleEndpointURI(newEndpoint));
            return true;
        }
        return false;
    }

    protected void registerEndpointMappings() throws InitialisationException {
        if (this.endpointMappings != null) {
            Map.Entry entry = null;
            Iterator iterator = this.endpointMappings.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = iterator.next();
                MuleManager.getInstance().registerEndpointIdentifier((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    protected void registerConnectors() throws UMOException {
        Map connectors;
        if (!MuleManager.getInstance().isInitialised() && (connectors = this.applicationContext.getBeansOfType(class$org$mule$umo$provider$UMOConnector == null ? (class$org$mule$umo$provider$UMOConnector = MuleEventMulticaster.class$("org.mule.umo.provider.UMOConnector")) : class$org$mule$umo$provider$UMOConnector, true, true)).size() > 0) {
            Iterator iterator = connectors.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                UMOConnector c = (UMOConnector)entry.getValue();
                if (c.getName() == null) {
                    c.setName(entry.getKey().toString());
                }
                MuleManager.getInstance().registerConnector(c);
            }
        }
    }

    protected void registerTransformers() throws UMOException {
        Map transformers;
        if (!MuleManager.getInstance().isInitialised() && (transformers = this.applicationContext.getBeansOfType(class$org$mule$umo$transformer$UMOTransformer == null ? (class$org$mule$umo$transformer$UMOTransformer = MuleEventMulticaster.class$("org.mule.umo.transformer.UMOTransformer")) : class$org$mule$umo$transformer$UMOTransformer, true, true)).size() > 0) {
            Iterator iterator = transformers.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                UMOTransformer t = (UMOTransformer)entry.getValue();
                if (t.getName() == null) {
                    t.setName(entry.getKey().toString());
                }
                MuleManager.getInstance().registerTransformer(t);
            }
        }
    }

    protected UMODescriptor getDefaultDescriptor() throws UMOException {
        UMOModel model = MuleManager.getInstance().getModel();
        UMODescriptor descriptor = model.getDescriptor(EVENT_MULTICASTER_DESCRIPTOR_NAME);
        if (descriptor != null) {
            model.unregisterComponent(descriptor);
        }
        descriptor = new MuleDescriptor(EVENT_MULTICASTER_DESCRIPTOR_NAME);
        if (this.subscriptions == null) {
            logger.info((Object)"No receive endpoints have been set, using default '*'");
            descriptor.setInboundEndpoint((UMOEndpoint)new MuleEndpoint("vm://*", true));
        } else {
            UMOInboundMessageRouter messageRouter = descriptor.getInboundRouter();
            for (int i = 0; i < this.subscriptions.length; ++i) {
                String subscription = this.subscriptions[i];
                MuleEndpointURI endpointUri = new MuleEndpointURI(subscription);
                messageRouter.addEndpoint(ImmutableMuleEndpoint.getOrCreateEndpointForUri((UMOEndpointURI)endpointUri, (String)"receiver"));
            }
        }
        descriptor.setImplementation((Object)"applicationEventMulticaster");
        return descriptor;
    }

    protected UMOFilter createFilter(String pattern) {
        try {
            if (this.getSubscriptionFilter() == null) {
                this.setSubscriptionFilter(class$org$mule$routing$filters$WildcardFilter == null ? (class$org$mule$routing$filters$WildcardFilter = MuleEventMulticaster.class$("org.mule.routing.filters.WildcardFilter")) : class$org$mule$routing$filters$WildcardFilter);
            }
            UMOFilter filter = (UMOFilter)ClassHelper.instanciateClass((Class)this.getSubscriptionFilter(), (Object[])new Object[]{pattern});
            return filter;
        }
        catch (Exception e) {
            logger.error((Object)("Failed to load filter: " + this.getSubscriptionFilter() + " : " + e.getMessage()));
            return new WildcardFilter(pattern);
        }
    }

    public Class getSubscriptionFilter() {
        return this.subscriptionFilter;
    }

    public void setSubscriptionFilter(Class subscriptionFilter) {
        this.subscriptionFilter = subscriptionFilter;
    }

    public Map getEndpointMappings() {
        return this.endpointMappings;
    }

    public void setEndpointMappings(Map endpointMappings) {
        this.endpointMappings = endpointMappings;
    }

    public String[] getSubscriptions() {
        return this.subscriptions;
    }

    public void setSubscriptions(String[] subscriptions) {
        this.subscriptions = subscriptions;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

