/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extras.spring.transaction;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import org.mule.transaction.AbstractSingleResourceTransaction;
import org.mule.umo.TransactionException;
import org.mule.umo.UMOTransaction;
import org.mule.umo.UMOTransactionFactory;
import org.springframework.jms.connection.ConnectionHolder;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class SpringTransactionFactory
implements UMOTransactionFactory {
    private PlatformTransactionManager manager;

    public UMOTransaction beginTransaction() throws TransactionException {
        return new SpringTransaction();
    }

    public boolean isTransacted() {
        return true;
    }

    public PlatformTransactionManager getManager() {
        return this.manager;
    }

    public void setManager(PlatformTransactionManager manager) {
        this.manager = manager;
    }

    public class SpringTransaction
    extends AbstractSingleResourceTransaction {
        protected TransactionStatus status;
        protected SynchronizedBoolean started = new SynchronizedBoolean(false);
        protected SynchronizedBoolean committed = new SynchronizedBoolean(false);
        protected SynchronizedBoolean rolledBack = new SynchronizedBoolean(false);
        protected SynchronizedBoolean rollbackOnly = new SynchronizedBoolean(false);

        public SpringTransaction() {
            this.status = SpringTransactionFactory.this.manager.getTransaction(null);
        }

        protected void doBegin() throws TransactionException {
        }

        protected void doCommit() throws TransactionException {
            SpringTransactionFactory.this.manager.commit(this.status);
        }

        protected void doRollback() throws TransactionException {
            SpringTransactionFactory.this.manager.rollback(this.status);
        }

        public Object getResource(Object key) {
            Object res = TransactionSynchronizationManager.getResource((Object)key);
            if (res != null) {
                if (res instanceof org.springframework.jdbc.datasource.ConnectionHolder) {
                    return ((org.springframework.jdbc.datasource.ConnectionHolder)res).getConnection();
                }
                if (res instanceof ConnectionHolder) {
                    return ((ConnectionHolder)res).getConnection();
                }
            }
            return res;
        }

        public boolean hasResource(Object key) {
            return this.getResource(key) != null;
        }

        public void bindResource(Object key, Object resource) throws TransactionException {
            throw new UnsupportedOperationException();
        }

        public void setRollbackOnly() {
            super.setRollbackOnly();
            this.status.setRollbackOnly();
        }
    }
}

