/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extras.spring.config;

import java.io.File;
import java.io.IOException;
import org.mule.extras.spring.config.MuleBeanDefinitionReader;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class MuleApplicationContext
extends AbstractXmlApplicationContext {
    private String[] configLocations;

    public MuleApplicationContext(String configLocation) {
        this(new String[]{configLocation});
    }

    public MuleApplicationContext(String[] configLocations) {
        this(configLocations, true);
    }

    public MuleApplicationContext(String[] configLocations, boolean refresh) throws BeansException {
        this.configLocations = configLocations;
        if (refresh) {
            this.refresh();
        }
    }

    protected String[] getConfigLocations() {
        return this.configLocations;
    }

    protected Resource getResourceByPath(String path) {
        File file;
        String filePath = path;
        if (filePath != null && filePath.startsWith("/")) {
            filePath = filePath.substring(1);
        }
        if ((file = new File(filePath)).exists()) {
            return new FileSystemResource(filePath);
        }
        return super.getResourceByPath(path);
    }

    protected void initBeanDefinitionReader(XmlBeanDefinitionReader xmlBeanDefinitionReader) {
        xmlBeanDefinitionReader.setValidating(false);
        super.initBeanDefinitionReader(xmlBeanDefinitionReader);
    }

    protected void loadBeanDefinitions(DefaultListableBeanFactory beanFactory) throws IOException {
        MuleBeanDefinitionReader beanDefinitionReader = new MuleBeanDefinitionReader((BeanDefinitionRegistry)beanFactory, this.configLocations.length);
        this.initBeanDefinitionReader(beanDefinitionReader);
        this.loadBeanDefinitions(beanDefinitionReader);
    }
}

