/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extras.spring.remoting;

import org.mule.config.i18n.Message;
import org.mule.umo.UMOEventContext;
import org.mule.umo.lifecycle.Callable;
import org.mule.umo.lifecycle.Initialisable;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.lifecycle.RecoverableException;
import org.mule.util.ClassHelper;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.remoting.support.RemoteInvocation;
import org.springframework.remoting.support.RemoteInvocationBasedExporter;
import org.springframework.remoting.support.RemoteInvocationExecutor;
import org.springframework.remoting.support.RemoteInvocationResult;

public class SpringHttpInvokerComponent
implements Initialisable,
Callable {
    private Delegate delegate = new Delegate();
    private Class serviceClass;
    private Class serviceInterface;
    private Object serviceBean;
    private boolean registerTraceInterceptor = false;
    private RemoteInvocationExecutor remoteInvocationExecutor;

    public void initialise() throws InitialisationException, RecoverableException {
        if (this.serviceClass == null && this.serviceBean == null) {
            throw new InitialisationException(new Message(183, (Object)"serviceClass or serviceBean"), (Object)this);
        }
        if (this.serviceInterface == null) {
            throw new InitialisationException(new Message(183, (Object)"serviceInterface"), (Object)this);
        }
        if (this.serviceClass != null && !this.serviceClass.equals("")) {
            Object service = null;
            try {
                service = ClassHelper.instanciateClass((Class)this.serviceClass, null);
            }
            catch (Exception e) {
                throw new InitialisationException((Throwable)e, (Object)this);
            }
            this.delegate.setService(service);
        } else if (this.serviceBean != null) {
            this.delegate.setService(this.serviceBean);
        }
        this.delegate.setServiceInterface(this.serviceInterface);
        this.delegate.setRegisterTraceInterceptor(this.registerTraceInterceptor);
        if (this.remoteInvocationExecutor != null) {
            this.delegate.setRemoteInvocationExecutor(this.remoteInvocationExecutor);
        }
        this.delegate.afterPropertiesSet();
    }

    public Class getServiceClass() {
        return this.serviceClass;
    }

    public void setServiceClass(Class serviceClass) {
        this.serviceClass = serviceClass;
    }

    public Object getServiceBean() {
        return this.serviceBean;
    }

    public void setServiceBean(Object serviceBean) {
        this.serviceBean = serviceBean;
    }

    public Class getServiceInterface() {
        return this.serviceInterface;
    }

    public void setServiceInterface(Class serviceInterface) {
        this.serviceInterface = serviceInterface;
    }

    public boolean isRegisterTraceInterceptor() {
        return this.registerTraceInterceptor;
    }

    public void setRegisterTraceInterceptor(boolean registerTraceInterceptor) {
        this.registerTraceInterceptor = registerTraceInterceptor;
    }

    public RemoteInvocationExecutor getRemoteInvocationExecutor() {
        return this.remoteInvocationExecutor;
    }

    public void setRemoteInvocationExecutor(RemoteInvocationExecutor remoteInvocationExecutor) {
        this.remoteInvocationExecutor = remoteInvocationExecutor;
    }

    public Object onCall(UMOEventContext eventContext) throws Exception {
        Object transformedMessage = eventContext.getTransformedMessage();
        RemoteInvocation ri = (RemoteInvocation)transformedMessage;
        Object rval = this.delegate.execute(ri);
        return rval;
    }

    private class Delegate
    extends RemoteInvocationBasedExporter
    implements InitializingBean {
        private Object proxy;

        private Delegate() {
        }

        public void afterPropertiesSet() {
            this.proxy = this.getProxyForService();
        }

        public Object execute(RemoteInvocation invocation) {
            try {
                Object value = this.invoke(invocation, this.proxy);
                return value;
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                return new RemoteInvocationResult(ex);
            }
        }
    }
}

