/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.http;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.httpclient.ConnectMethod;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.protocol.Protocol;
import org.mule.config.i18n.Message;
import org.mule.impl.MuleMessage;
import org.mule.providers.AbstractConnector;
import org.mule.providers.AbstractMessageDispatcher;
import org.mule.providers.NullPayload;
import org.mule.providers.http.HttpConnector;
import org.mule.providers.http.transformers.HttpClientMethodResponseToObject;
import org.mule.providers.http.transformers.ObjectToHttpClientMethodRequest;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.provider.DispatchException;
import org.mule.umo.provider.ReceiveException;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.transformer.UMOTransformer;

public class HttpClientMessageDispatcher
extends AbstractMessageDispatcher {
    private HttpConnector connector;
    private HttpState state;
    private UMOTransformer receiveTransformer;

    public HttpClientMessageDispatcher(HttpConnector connector) {
        super((AbstractConnector)connector);
        this.connector = connector;
        this.receiveTransformer = new HttpClientMethodResponseToObject();
        this.state = new HttpState();
        if (connector.getProxyUsername() != null) {
            this.state.setProxyCredentials(null, null, (Credentials)new UsernamePasswordCredentials(connector.getProxyUsername(), connector.getProxyPassword()));
        }
    }

    public void doDispatch(UMOEvent event) throws Exception {
        this.send(event);
    }

    public UMOConnector getConnector() {
        return this.connector;
    }

    public Object getDelegateSession() throws UMOException {
        return null;
    }

    public UMOMessage receive(UMOEndpointURI endpointUri, long timeout) throws Exception {
        if (endpointUri == null) {
            return null;
        }
        GetMethod httpMethod = new GetMethod(endpointUri.getAddress());
        HttpConnection connection = null;
        try {
            connection = this.getConnection(endpointUri.getUri());
            if (connection.isProxied() && connection.isSecure()) {
                httpMethod = new ConnectMethod((HttpMethod)httpMethod);
            }
            httpMethod.execute(this.state, connection);
            if (httpMethod.getStatusCode() == 200) {
                UMOMessage uMOMessage = (UMOMessage)this.receiveTransformer.transform((Object)httpMethod);
                return uMOMessage;
            }
            try {
                throw new ReceiveException(new Message("http", 3, (Object)httpMethod.getStatusLine().toString()), endpointUri, timeout);
            }
            catch (ReceiveException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ReceiveException(endpointUri, timeout, (Throwable)e);
            }
        }
        finally {
            if (httpMethod != null) {
                httpMethod.releaseConnection();
            }
        }
    }

    public UMOMessage doSend(UMOEvent event) throws Exception {
        String method = (String)event.getProperty("http.method", (Object)"POST");
        URI uri = event.getEndpoint().getEndpointURI().getUri();
        HttpMethod httpMethod = null;
        Object body = event.getTransformedMessage();
        if (body instanceof HttpMethod) {
            httpMethod = (HttpMethod)body;
        } else if ("GET".equals(method) || body instanceof NullPayload) {
            httpMethod = new GetMethod(uri.toString());
        } else {
            PostMethod postMethod = new PostMethod(uri.toString());
            if (body instanceof String) {
                ObjectToHttpClientMethodRequest trans = new ObjectToHttpClientMethodRequest();
                httpMethod = (HttpMethod)trans.transform(body.toString());
            } else if (body instanceof HttpMethod) {
                httpMethod = (HttpMethod)body;
            } else {
                byte[] buffer = event.getTransformedMessageAsBytes();
                postMethod.setRequestBody((InputStream)new ByteArrayInputStream(buffer));
                postMethod.setRequestContentLength(buffer.length);
                httpMethod = postMethod;
            }
        }
        HttpConnection connection = null;
        try {
            connection = this.getConnection(uri);
            if (connection.isProxied() && connection.isSecure()) {
                httpMethod = new ConnectMethod(httpMethod);
            }
            httpMethod.setDoAuthentication(true);
            httpMethod.execute(this.state, connection);
            Properties h = new Properties();
            Header[] headers = httpMethod.getRequestHeaders();
            for (int i = 0; i < headers.length; ++i) {
                h.setProperty(headers[i].getName(), headers[i].getValue());
            }
            String status = String.valueOf(httpMethod.getStatusCode());
            h.setProperty("http.status", status);
            this.logger.debug((Object)("Http response is: " + status));
            MuleMessage muleMessage = new MuleMessage((Object)httpMethod.getResponseBodyAsString(), (Map)h);
            return muleMessage;
        }
        catch (Exception e) {
            throw new DispatchException(event.getMessage(), event.getEndpoint(), (Throwable)e);
        }
        finally {
            if (httpMethod != null) {
                httpMethod.releaseConnection();
            }
        }
    }

    protected HttpConnection getConnection(URI uri) throws URISyntaxException {
        HttpConnection connection = null;
        Protocol protocol = Protocol.getProtocol((String)this.connector.getProtocol().toLowerCase());
        String host = uri.getHost();
        int port = uri.getPort();
        connection = new HttpConnection(host, port, protocol);
        connection.setProxyHost(this.connector.getProxyHostname());
        connection.setProxyPort(this.connector.getProxyPort());
        return connection;
    }

    public void doDispose() {
        this.state = null;
    }
}

