/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.http;

import java.util.Map;
import org.mule.providers.AbstractMessageAdapter;
import org.mule.umo.MessagingException;
import org.mule.umo.provider.MessageTypeNotSupportedException;

public class HttpMessageAdapter
extends AbstractMessageAdapter {
    private byte[] message = null;
    private boolean http11 = true;

    public HttpMessageAdapter(Object message) throws MessagingException {
        String temp;
        if (message instanceof Object[]) {
            this.message = (byte[])((Object[])message)[0];
            if (((Object[])message).length > 1) {
                this.properties = (Map)((Object[])message)[1];
            }
        } else if (message instanceof byte[]) {
            this.message = (byte[])message;
        } else {
            throw new MessageTypeNotSupportedException(message, ((Object)((Object)this)).getClass());
        }
        if ("HTTP/1.0".equalsIgnoreCase(temp = (String)this.properties.get("http.version"))) {
            this.http11 = false;
        }
    }

    public Object getPayload() {
        return this.message;
    }

    public boolean isBinary() {
        return this.message != null;
    }

    public byte[] getPayloadAsBytes() throws Exception {
        return this.message;
    }

    public String getPayloadAsString() throws Exception {
        return new String(this.message);
    }

    public Object getProperty(Object key) {
        if ("Keep-Alive".equals(key) || "Connection".equals(key)) {
            if (!this.http11) {
                String connection = (String)super.getProperty((Object)"Connection");
                if (connection != null && connection.equalsIgnoreCase("close")) {
                    return "false";
                }
                return "true";
            }
            return super.getProperty((Object)"Connection") != null ? "true" : "false";
        }
        return super.getProperty(key);
    }
}

