/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.http.servlet;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mule.MuleManager;
import org.mule.config.i18n.Message;
import org.mule.impl.MuleMessage;
import org.mule.providers.AbstractMessageReceiver;
import org.mule.providers.http.servlet.MuleReceiverServlet;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.EndpointException;
import org.mule.umo.endpoint.EndpointNotFoundException;
import org.mule.umo.endpoint.MalformedEndpointException;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.provider.UMOMessageReceiver;

public class MuleRESTReceiverServlet
extends MuleReceiverServlet {
    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        try {
            if (httpServletRequest.getParameter("endpoint") != null) {
                UMOEndpoint endpoint = this.getEndpointForURI(httpServletRequest);
                String timeoutString = httpServletRequest.getParameter("timeout");
                long to = this.timeout;
                if (timeoutString != null) {
                    to = Long.valueOf(timeoutString);
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Making request using endpoint: " + endpoint.toString() + " timeout is: " + to));
                }
                UMOMessage returnMessage = endpoint.getConnector().getDispatcher("ANY").receive(endpoint.getEndpointURI(), to);
                this.writeResponse(httpServletResponse, returnMessage);
            } else {
                AbstractMessageReceiver receiver = this.getReceiverForURI(httpServletRequest);
                httpServletRequest.setAttribute("org.mule.servlet.payload.param", (Object)this.payloadParameterName);
                MuleMessage message = new MuleMessage(receiver.getConnector().getMessageAdapter((Object)httpServletRequest));
                UMOMessage returnMessage = receiver.routeMessage((UMOMessage)message, true);
                this.writeResponse(httpServletResponse, returnMessage);
            }
        }
        catch (Exception e) {
            this.handleException(e, "Failed to route event through Servlet Receiver", httpServletResponse);
        }
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        try {
            AbstractMessageReceiver receiver = this.getReceiverForURI(httpServletRequest);
            httpServletRequest.setAttribute("org.mule.servlet.payload.param", (Object)this.payloadParameterName);
            MuleMessage message = new MuleMessage(receiver.getConnector().getMessageAdapter((Object)httpServletRequest));
            UMOMessage returnMessage = receiver.routeMessage((UMOMessage)message, true);
            this.writeResponse(httpServletResponse, returnMessage);
        }
        catch (Exception e) {
            this.handleException(e, "Failed to Post event to Mule", httpServletResponse);
        }
    }

    protected void doPut(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        try {
            AbstractMessageReceiver receiver = this.getReceiverForURI(httpServletRequest);
            httpServletRequest.setAttribute("org.mule.servlet.payload.param", (Object)this.payloadParameterName);
            MuleMessage message = new MuleMessage(receiver.getConnector().getMessageAdapter((Object)httpServletRequest));
            receiver.routeMessage((UMOMessage)message, MuleManager.getConfiguration().isSynchronous());
            httpServletResponse.setStatus(201);
            if (this.feedback) {
                httpServletResponse.getWriter().write("Item was created at endpointUri: " + receiver.getEndpointURI());
            }
        }
        catch (Exception e) {
            this.handleException(e, "Failed to Post event to Mule" + e.getMessage(), httpServletResponse);
        }
    }

    protected void doDelete(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        try {
            UMOMessage returnMessage;
            UMOEndpoint endpoint = this.getEndpointForURI(httpServletRequest);
            String timeoutString = httpServletRequest.getParameter("timeout");
            long to = this.timeout;
            if (timeoutString != null) {
                to = Long.valueOf(timeoutString);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Making request using endpoint: " + endpoint.toString() + " timeout is: " + to));
            }
            if ((returnMessage = endpoint.getConnector().getDispatcher("ANY").receive(endpoint.getEndpointURI(), to)) != null) {
                httpServletResponse.setStatus(200);
            } else {
                httpServletResponse.setStatus(204);
            }
        }
        catch (Exception e) {
            this.handleException(e, "Failed to Delete mule event via receive using uri: " + httpServletRequest.getPathInfo(), httpServletResponse);
        }
    }

    protected UMOEndpoint getEndpointForURI(HttpServletRequest httpServletRequest) throws EndpointException, MalformedEndpointException {
        String endpointName = httpServletRequest.getParameter("endpoint");
        if (endpointName == null) {
            throw new EndpointException(new Message("http", 8, (Object)"endpoint"));
        }
        UMOEndpoint endpoint = MuleManager.getInstance().lookupEndpoint(endpointName);
        if (endpoint == null) {
            UMOMessageReceiver receiver = (UMOMessageReceiver)this.getReceivers().get(endpointName);
            if (receiver == null) {
                throw new EndpointNotFoundException(endpointName);
            }
            endpoint = receiver.getEndpoint();
        }
        return endpoint;
    }
}

