/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.http.servlet;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.umo.UMOMessage;

public abstract class AbstractReceiverServlet
extends HttpServlet {
    protected transient Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    public static final String REQUEST_TIMEOUT_PROPERTY = "org.mule.servlet.timeout";
    public static final String FEEDBACK_PROPERTY = "org.mule.servlet.feedback";
    public static final String DEFAULT_CONTENT_TYPE_PROPERTY = "org.mule.servlet.default.content.type";
    public static final String PAYLOAD_PARAMETER_NAME = "org.mule.servlet.payload.param";
    public static final String DEFAULT_PAYLOAD_PARAMETER_NAME = "payload";
    public static final long DEFAULT_GET_TIMEOUT = 20000L;
    protected String payloadParameterName;
    protected long timeout = 20000L;
    protected boolean feedback = true;
    protected String defaultContentType = "text/plain";

    public final void init() throws ServletException {
        this.doInit();
    }

    public final void init(ServletConfig servletConfig) throws ServletException {
        String timeoutString = servletConfig.getInitParameter(REQUEST_TIMEOUT_PROPERTY);
        if (timeoutString != null) {
            this.timeout = Long.valueOf(timeoutString);
        }
        this.logger.info((Object)("Default request timeout for GET methods is: " + this.timeout));
        String feedbackString = servletConfig.getInitParameter(FEEDBACK_PROPERTY);
        if (feedbackString != null) {
            this.feedback = Boolean.valueOf(feedbackString);
        }
        this.logger.info((Object)("feedback is set to: " + this.feedback));
        String ct = servletConfig.getInitParameter(DEFAULT_CONTENT_TYPE_PROPERTY);
        if (ct != null) {
            this.defaultContentType = ct;
        }
        this.logger.info((Object)("Default content type is: " + this.defaultContentType));
        this.payloadParameterName = servletConfig.getInitParameter(PAYLOAD_PARAMETER_NAME);
        if (this.payloadParameterName == null) {
            this.payloadParameterName = DEFAULT_PAYLOAD_PARAMETER_NAME;
        }
        this.logger.info((Object)("Using payload param name: " + this.payloadParameterName));
        this.doInit(servletConfig);
    }

    protected void doInit(ServletConfig servletConfig) throws ServletException {
    }

    protected void doInit() throws ServletException {
    }

    protected void writeResponse(HttpServletResponse response, UMOMessage message) throws Exception {
        if (message == null) {
            response.setStatus(204);
            if (this.feedback) {
                response.setStatus(200);
                response.getWriter().write("Action was processed successfully. There was no result");
            }
        } else {
            String contentType = (String)message.getProperty((Object)"Content-Type");
            if (contentType == null) {
                contentType = this.defaultContentType;
            }
            if (!contentType.startsWith("text")) {
                response.setContentType(contentType);
                response.getOutputStream().write(message.getPayloadAsBytes());
            } else {
                response.setContentType(contentType);
                response.getWriter().write(message.getPayloadAsString());
            }
            response.setStatus(200);
        }
    }

    protected void handleException(Throwable exception, String message, HttpServletResponse response) {
        this.logger.error((Object)("message: " + exception.getMessage()), exception);
        response.setStatus(500);
        try {
            response.sendError(500, message + ": " + exception.getMessage());
        }
        catch (IOException e) {
            this.logger.error((Object)("Failed to sendError on response: " + e.getMessage()), (Throwable)e);
        }
    }
}

