/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.http;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.resource.spi.work.Work;
import org.mule.config.i18n.Message;
import org.mule.impl.MuleMessage;
import org.mule.impl.RequestContext;
import org.mule.impl.ResponseOutputStream;
import org.mule.providers.AbstractMessageReceiver;
import org.mule.providers.ConnectException;
import org.mule.providers.http.HttpConnector;
import org.mule.providers.http.RequestInputStream;
import org.mule.providers.tcp.TcpMessageReceiver;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.provider.UMOMessageAdapter;
import org.mule.umo.transformer.UMOTransformer;
import org.mule.util.monitor.Expirable;

public class HttpMessageReceiver
extends TcpMessageReceiver {
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$java$lang$Object;

    public HttpMessageReceiver(UMOConnector connector, UMOComponent component, UMOEndpoint endpoint) throws InitialisationException {
        super(connector, component, endpoint);
    }

    protected UMOTransformer getResponseTransformer() throws InitialisationException {
        UMOTransformer transformer = super.getResponseTransformer();
        if (transformer == null) {
            throw new InitialisationException(new Message("http", 1), (Object)this);
        }
        if (!(transformer.getReturnClass().equals(class$java$lang$String == null ? (class$java$lang$String = HttpMessageReceiver.class$("java.lang.String")) : class$java$lang$String) || transformer.getReturnClass().equals(array$B == null ? (array$B = HttpMessageReceiver.class$("[B")) : array$B) || transformer.getReturnClass().equals(class$java$lang$Object == null ? (class$java$lang$Object = HttpMessageReceiver.class$("java.lang.Object")) : class$java$lang$Object))) {
            throw new InitialisationException(new Message("http", 2, (Object)this.getConnector().getName()), (Object)this);
        }
        return transformer;
    }

    protected Work createWork(Socket socket) throws SocketException {
        return new HttpWorker(socket);
    }

    public void doConnect() throws ConnectException {
        if (this.shouldConnect()) {
            super.doConnect();
        }
    }

    protected boolean shouldConnect() {
        StringBuffer requestUri = new StringBuffer();
        requestUri.append(this.endpoint.getProtocol()).append("://");
        requestUri.append(this.endpoint.getEndpointURI().getHost());
        requestUri.append(":").append(this.endpoint.getEndpointURI().getPort());
        requestUri.append("*");
        AbstractMessageReceiver[] temp = this.connector.getReceivers(requestUri.toString());
        for (int i = 0; i < temp.length; ++i) {
            AbstractMessageReceiver abstractMessageReceiver = temp[i];
            if (!abstractMessageReceiver.isConnected()) continue;
            return false;
        }
        return true;
    }

    public void doDispose() {
        super.doDispose();
    }

    protected AbstractMessageReceiver getTargetReceiver(UMOMessage message, UMOEndpoint endpoint) throws ConnectException {
        String path = (String)message.getProperty((Object)"http.request");
        int i = path.indexOf("?");
        if (i > -1) {
            path = path.substring(0, i);
        }
        StringBuffer requestUri = new StringBuffer();
        requestUri.append(endpoint.getProtocol()).append("://");
        requestUri.append(endpoint.getEndpointURI().getHost());
        requestUri.append(":").append(endpoint.getEndpointURI().getPort());
        AbstractMessageReceiver receiver = this.connector.getReceiver(requestUri.toString());
        if (receiver == null && !"/".equals(path)) {
            int x = path.lastIndexOf("/");
            if (x > 1 && path.indexOf(".") > x) {
                requestUri.append(path.substring(0, x));
            } else {
                requestUri.append(path);
            }
            receiver = this.connector.getReceiver(requestUri.toString());
        }
        if (receiver == null) {
            throw new ConnectException(new Message(179, (Object)requestUri.toString()), (Object)this);
        }
        return receiver;
    }

    protected byte[] parseRequest(InputStream is, Properties p) throws IOException {
        byte[] payload;
        RequestInputStream req = new RequestInputStream(is);
        String startLine = null;
        do {
            try {
                startLine = req.readline();
            }
            catch (IOException e) {
                this.logger.debug((Object)e.getMessage());
            }
            if (startLine != null) continue;
            return null;
        } while (startLine.trim().length() == 0);
        StringTokenizer tokenizer = new StringTokenizer(startLine);
        String method = tokenizer.nextToken();
        String request = tokenizer.nextToken();
        String httpVersion = tokenizer.nextToken();
        p.setProperty("http.method", method);
        p.setProperty("http.request", request);
        p.setProperty("http.version", httpVersion);
        this.readHeaders(req, p);
        if (method.equals("GET")) {
            payload = request.getBytes();
        } else {
            String contentLengthHeader = p.getProperty("Content-Length", null);
            if (contentLengthHeader == null) {
                throw new IllegalStateException("Content-Length header must be set");
            }
            int contentLength = Integer.parseInt(contentLengthHeader);
            byte[] buffer = new byte[contentLength];
            int length = -1;
            for (int offset = req.read(buffer); offset >= 0 && offset < buffer.length && (length = req.read(buffer, offset, buffer.length - offset)) != -1; offset += length) {
            }
            payload = buffer;
        }
        return payload;
    }

    private void readHeaders(RequestInputStream is, Properties p) throws IOException {
        String line;
        String currentKey = null;
        while ((line = is.readline()) != null && line.length() != 0) {
            if (!Character.isSpaceChar(line.charAt(0))) {
                int index = line.indexOf(58);
                if (index < 0) continue;
                currentKey = line.substring(0, index).trim();
                if (currentKey.startsWith("X-MULE_")) {
                    currentKey = currentKey.substring(2);
                }
                String value = line.substring(index + 1).trim();
                p.setProperty(currentKey, value);
                continue;
            }
            if (currentKey == null) continue;
            String value = p.getProperty(currentKey);
            p.setProperty(currentKey, value + "\r\n\t" + line.trim());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class HttpWorker
    extends TcpMessageReceiver.TcpWorker
    implements Expirable {
        public HttpWorker(Socket socket) throws SocketException {
            super((TcpMessageReceiver)HttpMessageReceiver.this, socket);
            boolean keepAlive = ((HttpConnector)HttpMessageReceiver.this.connector).isKeepAlive();
            if (keepAlive) {
                socket.setKeepAlive(true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                boolean keepAlive;
                this.dataIn = new DataInputStream(new BufferedInputStream(this.socket.getInputStream()));
                this.dataOut = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
                do {
                    if (HttpMessageReceiver.this.disposing.get() || this.socket.isClosed()) {
                        HttpMessageReceiver.this.logger.debug((Object)"Peer closed connection");
                        break;
                    }
                    Properties headers = new Properties();
                    byte[] payload = HttpMessageReceiver.this.parseRequest(this.dataIn, headers);
                    if (payload == null) {
                        break;
                    }
                    UMOMessageAdapter adapter = HttpMessageReceiver.this.connector.getMessageAdapter((Object)new Object[]{payload, headers});
                    keepAlive = adapter.getBooleanProperty("Keep-Alive", true);
                    MuleMessage message = new MuleMessage(adapter);
                    if (HttpMessageReceiver.this.logger.isDebugEnabled()) {
                        HttpMessageReceiver.this.logger.debug(message.getProperty((Object)"http.request"));
                    }
                    ResponseOutputStream os = new ResponseOutputStream((OutputStream)this.dataOut, this.socket);
                    AbstractMessageReceiver receiver = HttpMessageReceiver.this.getTargetReceiver((UMOMessage)message, HttpMessageReceiver.this.endpoint);
                    UMOMessage returnMessage = receiver.routeMessage((UMOMessage)message, HttpMessageReceiver.this.endpoint.isSynchronous(), (OutputStream)os);
                    if (returnMessage == null) {
                        returnMessage = new MuleMessage((Object)"", null);
                    }
                    RequestContext.rewriteEvent((UMOMessage)returnMessage);
                    Object response = HttpMessageReceiver.this.responseTransformer.transform(returnMessage.getPayload());
                    if (response instanceof byte[]) {
                        this.dataOut.write((byte[])response);
                    } else {
                        this.dataOut.write(response.toString().getBytes());
                    }
                    this.dataOut.flush();
                } while (this.socket.isConnected() && keepAlive);
            }
            catch (Exception e) {
                boolean keepAlive = false;
                HttpMessageReceiver.this.handleException(e);
            }
            finally {
                this.dispose();
            }
        }

        public void expired() {
            HttpMessageReceiver.this.logger.debug((Object)"Keep alive timed out");
            this.dispose();
        }
    }
}

