/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.http;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import org.mule.config.i18n.Message;
import org.mule.impl.MuleMessage;
import org.mule.providers.PollingMessageReceiver;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.provider.UMOMessageAdapter;

public class PollingHttpMessageReceiver
extends PollingMessageReceiver {
    private URL pollUrl;
    private int defaultBufferSize = 32768;

    public PollingHttpMessageReceiver(UMOConnector connector, UMOComponent component, UMOEndpoint endpoint) throws InitialisationException {
        this(connector, component, endpoint, new Long(1000L));
    }

    public PollingHttpMessageReceiver(UMOConnector connector, UMOComponent component, UMOEndpoint endpoint, Long frequency) throws InitialisationException {
        super(connector, component, endpoint, frequency);
        try {
            this.pollUrl = new URL(endpoint.getEndpointURI().getAddress());
        }
        catch (MalformedURLException e) {
            throw new InitialisationException(new Message(154, (Object)("url: " + endpoint.getEndpointURI().getAddress())), (Throwable)e, (Object)this);
        }
    }

    public void poll() throws Exception {
        HttpURLConnection connection = (HttpURLConnection)this.pollUrl.openConnection();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int len = 0;
        int bytesWritten = 0;
        int contentLength = connection.getContentLength();
        boolean contentLengthNotSet = false;
        if (contentLength < 0) {
            contentLength = this.defaultBufferSize;
            contentLengthNotSet = true;
        }
        byte[] buffer = new byte[contentLength];
        InputStream is = connection.getInputStream();
        while (bytesWritten != contentLength) {
            len = is.read(buffer);
            if (len != -1) {
                baos.write(buffer, 0, len);
                bytesWritten += len;
                continue;
            }
            if (!contentLengthNotSet) continue;
            contentLength = bytesWritten;
        }
        buffer = baos.toByteArray();
        baos.close();
        UMOMessageAdapter adapter = this.connector.getMessageAdapter((Object)new Object[]{buffer, connection.getHeaderFields()});
        connection.disconnect();
        MuleMessage message = new MuleMessage(adapter);
        this.routeMessage((UMOMessage)message, this.endpoint.isSynchronous());
    }

    public void doConnect() throws Exception {
        URL url = null;
        String connectUrl = (String)this.endpoint.getProperties().get("connectUrl");
        url = connectUrl == null ? this.pollUrl : new URL(connectUrl);
        this.logger.debug((Object)("Using url to connect: " + this.pollUrl.toString()));
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.disconnect();
    }

    public void doDisconnect() throws Exception {
    }
}

