/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.http;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.resource.spi.work.Work;
import org.apache.commons.httpclient.ChunkedInputStream;
import org.mule.config.i18n.Message;
import org.mule.impl.MuleEvent;
import org.mule.impl.MuleMessage;
import org.mule.impl.MuleSession;
import org.mule.impl.RequestContext;
import org.mule.impl.ResponseOutputStream;
import org.mule.providers.AbstractMessageReceiver;
import org.mule.providers.ConnectException;
import org.mule.providers.http.HttpConnector;
import org.mule.providers.http.HttpConstants;
import org.mule.providers.http.RequestInputStream;
import org.mule.providers.tcp.TcpMessageReceiver;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOMessage;
import org.mule.umo.UMOSession;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.provider.UMOMessageAdapter;
import org.mule.util.PropertiesHelper;
import org.mule.util.monitor.Expirable;

public class HttpMessageReceiver
extends TcpMessageReceiver {
    public HttpMessageReceiver(UMOConnector connector, UMOComponent component, UMOEndpoint endpoint) throws InitialisationException {
        super(connector, component, endpoint);
    }

    protected Work createWork(Socket socket) throws SocketException {
        return new HttpWorker(socket);
    }

    public void doConnect() throws ConnectException {
        if (this.shouldConnect()) {
            super.doConnect();
        }
    }

    protected boolean shouldConnect() {
        StringBuffer requestUri = new StringBuffer();
        requestUri.append(this.endpoint.getProtocol()).append("://");
        requestUri.append(this.endpoint.getEndpointURI().getHost());
        requestUri.append(":").append(this.endpoint.getEndpointURI().getPort());
        requestUri.append("*");
        AbstractMessageReceiver[] temp = this.connector.getReceivers(requestUri.toString());
        for (int i = 0; i < temp.length; ++i) {
            AbstractMessageReceiver abstractMessageReceiver = temp[i];
            if (!abstractMessageReceiver.isConnected()) continue;
            return false;
        }
        return true;
    }

    public void doDispose() {
        super.doDispose();
    }

    protected String getRequestPath(UMOMessage message) {
        String path = (String)message.getProperty((Object)"http.request");
        int i = path.indexOf("?");
        if (i > -1) {
            path = path.substring(0, i);
        }
        return path;
    }

    protected AbstractMessageReceiver getTargetReceiver(UMOMessage message, UMOEndpoint endpoint) throws ConnectException {
        String path = (String)message.getProperty((Object)"http.request");
        int i = path.indexOf("?");
        if (i > -1) {
            path = path.substring(0, i);
        }
        StringBuffer requestUri = new StringBuffer();
        requestUri.append(endpoint.getProtocol()).append("://");
        requestUri.append(endpoint.getEndpointURI().getHost());
        requestUri.append(":").append(endpoint.getEndpointURI().getPort());
        AbstractMessageReceiver receiver = this.connector.getReceiver(requestUri.toString());
        if (receiver == null && !"/".equals(path)) {
            int x = path.lastIndexOf("/");
            if (x > 1 && path.indexOf(".") > x) {
                requestUri.append(path.substring(0, x));
            } else {
                requestUri.append(path);
            }
            receiver = this.connector.getReceiver(requestUri.toString());
        }
        return receiver;
    }

    protected Object parseRequest(InputStream is, Properties p) throws IOException {
        RequestInputStream req = new RequestInputStream(is);
        Object payload = null;
        String startLine = null;
        do {
            try {
                startLine = req.readline();
            }
            catch (IOException e) {
                this.logger.debug((Object)e.getMessage());
            }
            if (startLine != null) continue;
            return null;
        } while (startLine.trim().length() == 0);
        StringTokenizer tokenizer = new StringTokenizer(startLine);
        String method = tokenizer.nextToken();
        String request = tokenizer.nextToken();
        String httpVersion = tokenizer.nextToken();
        p.setProperty("http.method", method);
        p.setProperty("http.request", request);
        p.setProperty("http.version", httpVersion);
        this.readHeaders(req, p);
        if (method.equals("GET")) {
            payload = request.getBytes();
        } else {
            boolean multipart = p.getProperty("Content-Type", "").indexOf("multipart/related") > -1;
            String contentLengthHeader = p.getProperty("Content-Length", null);
            String chunkedString = PropertiesHelper.getStringProperty((Map)p, (Object)"Transfer-Encoding", null);
            boolean chunked = "chunked".equalsIgnoreCase(chunkedString);
            if (contentLengthHeader == null && !chunked) {
                throw new IllegalStateException("Content-Length header must be set");
            }
            if (chunked) {
                byte[] buffer = new byte[32768];
                int length = -1;
                ChunkedInputStream cis = new ChunkedInputStream((InputStream)req);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                int offset = cis.read(buffer);
                if (offset == -1) {
                    return null;
                }
                baos.write(buffer, 0, offset);
                while (offset >= 0 && (length = cis.read(buffer, offset, buffer.length)) != -1) {
                    baos.write(buffer, offset, length);
                    offset += length;
                }
                payload = baos.toByteArray();
            } else {
                int contentLength = Integer.parseInt(contentLengthHeader);
                if (multipart) {
                    byte[] buffer = new byte[1024];
                    payload = File.createTempFile("mime", ".att");
                    ((File)payload).deleteOnExit();
                    FileOutputStream os = new FileOutputStream((File)payload);
                    int length = -1;
                    int offset = 0;
                    while (offset != contentLength) {
                        buffer = new byte[1024];
                        length = is.read(buffer);
                        if (length == -1) continue;
                        os.write(buffer, 0, length);
                        offset += length;
                    }
                    os.close();
                } else {
                    byte[] buffer = new byte[contentLength];
                    int length = -1;
                    for (int offset = req.read(buffer); offset >= 0 && offset < buffer.length && (length = req.read(buffer, offset, buffer.length - offset)) != -1; offset += length) {
                    }
                    payload = buffer;
                }
            }
        }
        return payload;
    }

    private void readHeaders(RequestInputStream is, Properties p) throws IOException {
        String line;
        String currentKey = null;
        while ((line = is.readline()) != null && line.length() != 0) {
            if (!Character.isSpaceChar(line.charAt(0))) {
                int index = line.indexOf(58);
                if (index < 0) continue;
                currentKey = line.substring(0, index).trim();
                if (currentKey.startsWith("X-MULE_")) {
                    currentKey = currentKey.substring(2);
                } else {
                    String normalizedKey = (String)HttpConstants.ALL_HEADER_NAMES.get(currentKey);
                    if (normalizedKey != null) {
                        currentKey = normalizedKey;
                    }
                }
                String value = line.substring(index + 1).trim();
                p.setProperty(currentKey, value);
                continue;
            }
            if (currentKey == null) continue;
            String value = p.getProperty(currentKey);
            p.setProperty(currentKey, value + "\r\n\t" + line.trim());
        }
    }

    private class HttpWorker
    extends TcpMessageReceiver.TcpWorker
    implements Expirable {
        public HttpWorker(Socket socket) throws SocketException {
            super((TcpMessageReceiver)HttpMessageReceiver.this, socket);
            boolean keepAlive = ((HttpConnector)HttpMessageReceiver.this.connector).isKeepAlive();
            if (keepAlive) {
                socket.setKeepAlive(true);
                socket.setSoTimeout(((HttpConnector)HttpMessageReceiver.this.connector).getKeepAliveTimeout());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean keepAlive = ((HttpConnector)HttpMessageReceiver.this.connector).isKeepAlive();
            try {
                Properties headers;
                Object payload;
                this.dataIn = new DataInputStream(new BufferedInputStream(this.socket.getInputStream()));
                this.dataOut = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
                while ((payload = HttpMessageReceiver.this.parseRequest(this.dataIn, headers = new Properties())) != null) {
                    UMOMessageAdapter adapter = HttpMessageReceiver.this.connector.getMessageAdapter((Object)new Object[]{payload, headers});
                    MuleMessage message = new MuleMessage((Object)adapter);
                    if (HttpMessageReceiver.this.logger.isDebugEnabled()) {
                        HttpMessageReceiver.this.logger.debug(message.getProperty((Object)"http.request"));
                    }
                    ResponseOutputStream os = new ResponseOutputStream((OutputStream)this.dataOut, this.socket);
                    AbstractMessageReceiver receiver = HttpMessageReceiver.this.getTargetReceiver((UMOMessage)message, HttpMessageReceiver.this.endpoint);
                    UMOMessage returnMessage = null;
                    boolean transformResponse = false;
                    if (receiver != null) {
                        returnMessage = receiver.routeMessage((UMOMessage)message, HttpMessageReceiver.this.endpoint.isSynchronous(), (OutputStream)os);
                        if (returnMessage == null) {
                            returnMessage = new MuleMessage((Object)"");
                            transformResponse = true;
                            RequestContext.rewriteEvent((UMOMessage)returnMessage);
                        }
                    } else {
                        transformResponse = true;
                        String failedPath = HttpMessageReceiver.this.endpoint.getEndpointURI().getScheme() + "://" + HttpMessageReceiver.this.endpoint.getEndpointURI().getHost() + ":" + HttpMessageReceiver.this.endpoint.getEndpointURI().getPort() + HttpMessageReceiver.this.getRequestPath((UMOMessage)message);
                        HttpMessageReceiver.this.logger.debug((Object)("Failed to bind to " + failedPath));
                        returnMessage = new MuleMessage((Object)new Message(179, (Object)failedPath).toString());
                        returnMessage.setIntProperty("http.status", 404);
                        RequestContext.setEvent((UMOEvent)new MuleEvent(returnMessage, HttpMessageReceiver.this.endpoint, (UMOSession)new MuleSession(), true));
                    }
                    Object response = returnMessage.getPayload();
                    if (transformResponse) {
                        response = HttpMessageReceiver.this.connector.getDefaultResponseTransformer().transform(response);
                    }
                    if (response instanceof byte[]) {
                        this.dataOut.write((byte[])response);
                    } else {
                        this.dataOut.write(response.toString().getBytes());
                    }
                    this.dataOut.flush();
                    if (!this.socket.isClosed() && !HttpMessageReceiver.this.disposing.get() && keepAlive) continue;
                }
                if (HttpMessageReceiver.this.logger.isDebugEnabled() && this.socket.isClosed()) {
                    HttpMessageReceiver.this.logger.debug((Object)"Peer closed connection");
                }
            }
            catch (Exception e) {
                HttpMessageReceiver.this.handleException(e);
            }
            finally {
                this.dispose();
            }
        }

        public void expired() {
            HttpMessageReceiver.this.logger.debug((Object)"Keep alive timed out");
            this.dispose();
        }
    }
}

