/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.http.jetty;

import org.mortbay.http.HttpContext;
import org.mortbay.http.HttpHandler;
import org.mortbay.http.HttpListener;
import org.mortbay.http.SocketListener;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.util.InetAddrPort;
import org.mule.config.i18n.Message;
import org.mule.providers.AbstractMessageReceiver;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOException;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.lifecycle.LifecycleException;
import org.mule.umo.provider.UMOConnector;

public class JettyHttpMessageReceiver
extends AbstractMessageReceiver {
    private Server httpServer;
    static /* synthetic */ Class class$org$mule$providers$http$servlet$MuleRESTReceiverServlet;
    static /* synthetic */ Class class$org$mule$providers$http$jetty$JettyReceiverServlet;

    public JettyHttpMessageReceiver(UMOConnector connector, UMOComponent component, UMOEndpoint endpoint) throws InitialisationException {
        super(connector, component, endpoint);
    }

    public void doConnect() throws Exception {
        this.httpServer = new Server();
        SocketListener socketListener = new SocketListener(new InetAddrPort(this.endpoint.getEndpointURI().getPort()));
        this.httpServer.addListener((HttpListener)socketListener);
        String path = this.endpoint.getEndpointURI().getPath();
        if (path == null || "".equals(path)) {
            path = "/";
        }
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        HttpContext context = this.httpServer.getContext(path);
        context.setRequestLog(null);
        ServletHandler handler = new ServletHandler();
        if ("rest".equals(this.endpoint.getEndpointURI().getScheme())) {
            handler.addServlet("MuleRESTReceiverServlet", path + "*", (class$org$mule$providers$http$servlet$MuleRESTReceiverServlet == null ? (class$org$mule$providers$http$servlet$MuleRESTReceiverServlet = JettyHttpMessageReceiver.class$("org.mule.providers.http.servlet.MuleRESTReceiverServlet")) : class$org$mule$providers$http$servlet$MuleRESTReceiverServlet).getName());
        } else {
            handler.addServlet("JettyReceiverServlet", path + "*", (class$org$mule$providers$http$jetty$JettyReceiverServlet == null ? (class$org$mule$providers$http$jetty$JettyReceiverServlet = JettyHttpMessageReceiver.class$("org.mule.providers.http.jetty.JettyReceiverServlet")) : class$org$mule$providers$http$jetty$JettyReceiverServlet).getName());
        }
        context.addHandler((HttpHandler)handler);
        context.setAttribute("messageReceiver", (Object)this);
    }

    public void doDisconnect() throws Exception {
    }

    protected void doDispose() {
        try {
            this.httpServer.stop(false);
        }
        catch (InterruptedException e) {
            this.logger.error((Object)("Error disposing Jetty recevier on: " + this.endpoint.getEndpointURI().toString()), (Throwable)e);
        }
    }

    public void doStart() throws UMOException {
        try {
            this.httpServer.start();
        }
        catch (Exception e) {
            throw new LifecycleException(new Message(42, (Object)"Jetty Http Reciever"), (Throwable)e, (Object)this);
        }
    }

    public void doStop() throws UMOException {
        try {
            this.httpServer.stop(true);
        }
        catch (InterruptedException e) {
            throw new LifecycleException(new Message(41, (Object)"Jetty Http Reciever"), (Throwable)e, (Object)this);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

