/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.http.servlet;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.mule.config.i18n.Message;
import org.mule.providers.AbstractMessageAdapter;
import org.mule.umo.MessagingException;
import org.mule.umo.provider.MessageTypeNotSupportedException;
import org.mule.umo.provider.UMOMessageAdapter;
import org.mule.umo.provider.UniqueIdNotSupportedException;
import org.mule.util.Utility;

public class HttpRequestMessageAdapter
extends AbstractMessageAdapter {
    private Object message = null;
    private HttpServletRequest request;

    public HttpRequestMessageAdapter(Object message) throws MessagingException {
        if (message instanceof HttpServletRequest) {
            String key;
            this.setPayload((HttpServletRequest)message);
            Map parameterMap = this.request.getParameterMap();
            if (parameterMap != null && parameterMap.size() > 0) {
                this.properties.putAll(parameterMap);
            }
            Enumeration e = this.request.getAttributeNames();
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                this.properties.put(key, this.request.getAttribute(key));
            }
            e = this.request.getHeaderNames();
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                this.properties.put(key, this.request.getHeader(key));
            }
        } else {
            throw new MessageTypeNotSupportedException(message, ((Object)((Object)this)).getClass());
        }
    }

    public Object getPayload() {
        return this.message;
    }

    public boolean isBinary() {
        return this.message instanceof byte[];
    }

    public byte[] getPayloadAsBytes() throws Exception {
        if (this.isBinary()) {
            return (byte[])this.message;
        }
        return ((String)this.message).getBytes();
    }

    public String getPayloadAsString() throws Exception {
        if (this.isBinary()) {
            return new String((byte[])this.message);
        }
        return (String)this.message;
    }

    private void setPayload(HttpServletRequest message) throws MessagingException {
        try {
            String payload;
            this.request = message;
            String payloadParam = (String)this.request.getAttribute("org.mule.servlet.payload.param");
            if (payloadParam == null) {
                payloadParam = "payload";
            }
            if ((payload = this.request.getParameter(payloadParam)) == null) {
                if (this.isText(this.request.getContentType())) {
                    String line;
                    BufferedReader reader = this.request.getReader();
                    StringBuffer buffer = new StringBuffer();
                    while ((line = reader.readLine()) != null) {
                        buffer.append(line);
                        buffer.append(Utility.CRLF);
                    }
                    this.message = buffer.toString();
                } else {
                    ServletInputStream is = this.request.getInputStream();
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    byte[] buffer = new byte[32768];
                    int len = 0;
                    while ((len = is.read(buffer, len, buffer.length)) != -1) {
                        baos.write(buffer, 0, len);
                        if (len == buffer.length) continue;
                    }
                    baos.flush();
                    this.message = baos.toByteArray();
                    baos.close();
                }
            } else {
                this.message = payload;
            }
        }
        catch (IOException e) {
            throw new MessagingException(new Message("servlet", 3, (Object)this.request.getRequestURL().toString()), (Object)e);
        }
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public String getUniqueId() throws UniqueIdNotSupportedException {
        HttpSession session = null;
        try {
            session = this.getRequest().getSession();
        }
        catch (Exception e) {
            throw new UniqueIdNotSupportedException((UMOMessageAdapter)this, new Message(45, (Object)"Http session"));
        }
        if (session == null) {
            throw new UniqueIdNotSupportedException((UMOMessageAdapter)this, new Message(45, (Object)"Http session"));
        }
        return session.getId();
    }

    protected boolean isText(String contentType) {
        if (contentType == null) {
            return true;
        }
        return contentType.startsWith("text/");
    }

    public void setReplyTo(Object replyTo) {
        if (replyTo != null && replyTo.toString().startsWith("http")) {
            this.setProperty("Location", replyTo);
        }
        this.setProperty("MULE_CORRELATION_ID", replyTo);
    }

    public Object getReplyTo() {
        String replyto = (String)this.getProperty("MULE_REPLYTO");
        if (replyto == null) {
            replyto = (String)this.getProperty("Location");
        }
        return replyto;
    }
}

