/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.http.transformers;

import java.io.InputStream;
import java.net.URI;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.mule.config.i18n.Message;
import org.mule.providers.NullPayload;
import org.mule.providers.http.HttpConstants;
import org.mule.transformers.AbstractEventAwareTransformer;
import org.mule.umo.UMOEventContext;
import org.mule.umo.transformer.TransformerException;
import org.mule.umo.transformer.UMOTransformer;
import org.mule.util.Utility;

public class ObjectToHttpClientMethodRequest
extends AbstractEventAwareTransformer {
    static /* synthetic */ Class class$org$apache$commons$httpclient$HttpMethod;

    public ObjectToHttpClientMethodRequest() {
        this.setReturnClass(class$org$apache$commons$httpclient$HttpMethod == null ? (class$org$apache$commons$httpclient$HttpMethod = ObjectToHttpClientMethodRequest.class$("org.apache.commons.httpclient.HttpMethod")) : class$org$apache$commons$httpclient$HttpMethod);
    }

    private int addParameters(String queryString, PostMethod postMethod) {
        String currentParam;
        if (queryString == null || queryString.length() == 0) {
            return 0;
        }
        int equals = queryString.indexOf("&");
        if (equals > -1) {
            currentParam = queryString.substring(0, equals);
            queryString = queryString.substring(equals + 1);
        } else {
            currentParam = queryString;
            queryString = "";
        }
        int parameterIndex = -1;
        while (currentParam != "") {
            equals = currentParam.indexOf("=");
            if (equals > -1) {
                String paramName = currentParam.substring(0, equals);
                String paramValue = currentParam.substring(equals + 1);
                ++parameterIndex;
                postMethod.addParameter(paramName, paramValue);
            }
            if ((equals = queryString.indexOf("&")) > -1) {
                currentParam = queryString.substring(0, equals);
                queryString = queryString.substring(equals + 1);
                continue;
            }
            currentParam = queryString;
            queryString = "";
        }
        return parameterIndex + 1;
    }

    public Object transform(Object src, UMOEventContext context) throws TransformerException {
        String endpoint = (String)context.getProperty("MULE_ENDPOINT", null);
        if (endpoint == null) {
            throw new TransformerException(new Message(111, (Object)"MULE_ENDPOINT"), (UMOTransformer)this);
        }
        String method = (String)context.getProperty("http.method", (Object)"POST");
        try {
            URI uri = new URI(endpoint);
            GetMethod httpMethod = null;
            if ("GET".equals(method)) {
                httpMethod = new GetMethod(uri.toString());
                this.setHeaders((HttpMethod)httpMethod, context);
                String paramName = (String)context.getProperty("http.get.body.param", (Object)"body");
                String query = uri.getQuery();
                if (!(src instanceof NullPayload) && !"".equals(src)) {
                    query = query == null ? paramName + "=" + src.toString() : query + "&" + paramName + "=" + src.toString();
                }
                httpMethod.setQueryString(query);
            } else {
                PostMethod postMethod = new PostMethod(uri.toString());
                this.setHeaders((HttpMethod)postMethod, context);
                String paramName = (String)context.getProperty("http.post.body.param");
                if (paramName == null) {
                    this.addParameters(uri.getQuery(), postMethod);
                    if (!(context.getMessage().getPayload() instanceof NullPayload)) {
                        if (src instanceof String) {
                            postMethod.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(src.toString().getBytes()));
                        } else if (src instanceof InputStream) {
                            postMethod.setRequestEntity((RequestEntity)new InputStreamRequestEntity((InputStream)src));
                        } else {
                            byte[] buffer = Utility.objectToByteArray((Object)src);
                            postMethod.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(buffer));
                        }
                    }
                } else {
                    postMethod.addParameter(paramName, src.toString());
                }
                httpMethod = postMethod;
            }
            return httpMethod;
        }
        catch (Exception e) {
            throw new TransformerException((UMOTransformer)this, (Throwable)e);
        }
    }

    protected void setHeaders(HttpMethod httpMethod, UMOEventContext context) {
        Map p = context.getProperties();
        Iterator iterator = p.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry header = iterator.next();
            String headerName = header.getKey().toString();
            if (HttpConstants.REQUEST_HEADER_NAMES.get(headerName) != null || !(header.getValue() instanceof String)) continue;
            if (headerName.startsWith("MULE_")) {
                headerName = "X-" + headerName;
            }
            if (headerName.startsWith("Content-Length") && httpMethod.getResponseHeader("Content-Length") == null) {
                httpMethod.addRequestHeader(headerName, (String)header.getValue());
                continue;
            }
            httpMethod.addRequestHeader(headerName, (String)header.getValue());
        }
        if (context.getMessage().getPayload() instanceof InputStream) {
            httpMethod.addRequestHeader("Content-Type", "multipart/related");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

