/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.http.transformers;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import org.mule.MuleManager;
import org.mule.config.i18n.Message;
import org.mule.providers.NullPayload;
import org.mule.providers.http.HttpConstants;
import org.mule.transformers.AbstractEventAwareTransformer;
import org.mule.umo.UMOEventContext;
import org.mule.umo.UMOMessage;
import org.mule.umo.transformer.TransformerException;
import org.mule.umo.transformer.UMOTransformer;
import org.mule.util.Utility;

public class UMOMessageToHttpResponse
extends AbstractEventAwareTransformer {
    private SimpleDateFormat format = null;
    private String server = null;
    static /* synthetic */ Class class$java$lang$Object;

    public UMOMessageToHttpResponse() {
        this.registerSourceType(class$java$lang$Object == null ? (class$java$lang$Object = UMOMessageToHttpResponse.class$("java.lang.Object")) : class$java$lang$Object);
        this.setReturnClass(class$java$lang$Object == null ? (class$java$lang$Object = UMOMessageToHttpResponse.class$("java.lang.Object")) : class$java$lang$Object);
        this.format = new SimpleDateFormat("EEE, dd MMM yyyy hh:mm:ss zzz");
        this.server = MuleManager.getConfiguration().getProductName() == null ? "Mule/SNAPSHOT" : MuleManager.getConfiguration().getProductName() + "/" + MuleManager.getConfiguration().getProductVersion();
    }

    public Object transform(Object src, UMOEventContext context) throws TransformerException {
        UMOMessage m;
        String user;
        if (src instanceof NullPayload) {
            src = "";
        }
        int status = context.getIntProperty("http.status", 200);
        String version = (String)context.getProperty("http.version", (Object)HttpConstants.HTTP11);
        String date = this.format.format(new Date());
        byte[] response = null;
        String contentType = (String)context.getProperty("Content-Type", (Object)"text/plain");
        if (src instanceof byte[]) {
            response = (byte[])src;
        } else if (contentType.startsWith("text/")) {
            response = src.toString().getBytes();
        } else {
            try {
                response = Utility.objectToByteArray((Object)src);
            }
            catch (IOException e) {
                throw new TransformerException(new Message(110, (Object)"Object", (Object)"byte[]"), (UMOTransformer)this, (Throwable)e);
            }
        }
        StringBuffer httpMessage = new StringBuffer(512);
        httpMessage.append(version).append(" ");
        httpMessage.append(status).append(HttpConstants.CRLF);
        httpMessage.append("Date");
        httpMessage.append(": ").append(date).append(HttpConstants.CRLF);
        httpMessage.append("Server");
        httpMessage.append(": ").append(this.server).append(HttpConstants.CRLF);
        if (context.getProperty("Expires") == null) {
            httpMessage.append("Expires");
            httpMessage.append(": ").append(date).append(HttpConstants.CRLF);
        }
        httpMessage.append("Content-Type");
        if (contentType == null) {
            httpMessage.append(": ").append("text/xml").append(HttpConstants.CRLF);
        } else {
            httpMessage.append(": ").append(contentType).append(HttpConstants.CRLF);
        }
        httpMessage.append("Content-Length");
        httpMessage.append(": ").append(response.length).append(HttpConstants.CRLF);
        Iterator iterator = HttpConstants.RESPONSE_HEADER_NAMES.values().iterator();
        while (iterator.hasNext()) {
            String headerName = (String)iterator.next();
            String value = context.getStringProperty(headerName);
            if (value == null) continue;
            httpMessage.append(headerName).append(": ").append(value);
            httpMessage.append(HttpConstants.CRLF);
        }
        Map customHeaders = (Map)context.getProperty("http.custom.headers");
        if (customHeaders != null) {
            Iterator iterator2 = customHeaders.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry entry = iterator2.next();
                httpMessage.append(entry.getKey()).append(": ").append(entry.getValue());
                httpMessage.append(HttpConstants.CRLF);
            }
        }
        if ((user = (String)(m = context.getMessage()).getProperty((Object)"MULE_USER")) != null) {
            httpMessage.append("X-MULE_USER").append(": ").append(user);
            httpMessage.append(HttpConstants.CRLF);
        }
        if (m.getCorrelationId() != null) {
            httpMessage.append("X-MULE_CORRELATION_ID").append(": ").append(m.getCorrelationId());
            httpMessage.append(HttpConstants.CRLF);
            httpMessage.append("X-MULE_CORRELATION_GROUP_SIZE").append(": ").append(m.getCorrelationGroupSize());
            httpMessage.append(HttpConstants.CRLF);
            httpMessage.append("X-MULE_CORRELATION_SEQUENCE").append(": ").append(m.getCorrelationSequence());
            httpMessage.append(HttpConstants.CRLF);
        }
        if (m.getReplyTo() != null) {
            httpMessage.append("X-MULE_REPLYTO").append(": ").append(m.getReplyTo().toString());
            httpMessage.append(HttpConstants.CRLF);
        }
        httpMessage.append(HttpConstants.CRLF);
        byte[] resultPayload = new byte[httpMessage.length() + response.length];
        System.arraycopy(httpMessage.toString().getBytes(), 0, resultPayload, 0, httpMessage.length());
        System.arraycopy(response, 0, resultPayload, httpMessage.length(), response.length);
        if (contentType.startsWith("text/")) {
            return new String(resultPayload);
        }
        return resultPayload;
    }

    public boolean isAcceptNull() {
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

