/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.jbi;

import java.util.Iterator;
import java.util.Set;
import javax.activation.DataHandler;
import javax.jbi.messaging.NormalizedMessage;
import org.mule.providers.AbstractMessageAdapter;
import org.mule.umo.MessagingException;
import org.mule.umo.provider.MessageTypeNotSupportedException;

public class JbiMessageAdapter
extends AbstractMessageAdapter {
    private NormalizedMessage message;

    public JbiMessageAdapter(Object message) throws MessagingException {
        if (message instanceof NormalizedMessage) {
            this.message = (NormalizedMessage)message;
            Iterator iterator = this.message.getPropertyNames().iterator();
            while (iterator.hasNext()) {
                String s = (String)iterator.next();
                this.properties.put(s, this.message.getProperty(s));
            }
        } else {
            throw new MessageTypeNotSupportedException(message, ((Object)((Object)this)).getClass());
        }
    }

    public void setProperty(Object key, Object value) {
        this.message.setProperty(key.toString(), value);
    }

    public String getPayloadAsString() throws Exception {
        return new String();
    }

    public byte[] getPayloadAsBytes() throws Exception {
        return new byte[0];
    }

    public Object getPayload() {
        return this.message;
    }

    public Object getProperty(Object key) {
        return this.message.getProperty(key.toString());
    }

    public void addAttachment(String name, DataHandler dataHandler) throws Exception {
        this.message.addAttachment(name, dataHandler);
    }

    public void removeAttachment(String name) throws Exception {
        this.message.removeAttachment(name);
    }

    public DataHandler getAttachment(String name) {
        return this.message.getAttachment(name);
    }

    public Set getAttachmentNames() {
        return this.message.getAttachmentNames();
    }
}

