/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.jbi;

import javax.jbi.component.ComponentContext;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkException;
import org.mule.config.i18n.Message;
import org.mule.impl.MuleMessage;
import org.mule.providers.AbstractMessageReceiver;
import org.mule.providers.jbi.JbiConnector;
import org.mule.providers.jbi.JbiUtils;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.lifecycle.LifecycleException;
import org.mule.umo.provider.UMOConnector;

public class JbiMessageReceiver
extends AbstractMessageReceiver
implements Work {
    protected ComponentContext context;
    protected JbiConnector connector;
    protected String name;
    private DeliveryChannel deliveryChannel;

    public JbiMessageReceiver(UMOConnector connector, UMOComponent component, UMOEndpoint endpoint) throws InitialisationException {
        super(connector, component, endpoint);
        this.name = component.getDescriptor().getName() + ".jbiReceiver";
        this.connector = (JbiConnector)connector;
        this.context = this.connector.getComponentContext();
        this.deliveryChannel = this.connector.getDeliveryChannel();
    }

    public void doConnect() throws Exception {
    }

    public void doDisconnect() throws Exception {
    }

    public void doStart() throws UMOException {
        try {
            this.getWorkManager().scheduleWork((Work)this);
        }
        catch (WorkException e) {
            throw new LifecycleException(new Message(42, (Object)this.name), (Throwable)e, (Object)this);
        }
    }

    public void release() {
    }

    public void run() {
        while (this.connector.isStarted()) {
            try {
                MessageExchange me = this.deliveryChannel.accept();
                if (me == null) continue;
                this.getWorkManager().scheduleWork((Work)new MessageExchangeWorker(me));
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }

    protected void error(MessageExchange me, Exception e) throws MessagingException {
        if (e instanceof Fault) {
            me.setFault((Fault)e);
        } else {
            me.setError(e);
        }
        me.setStatus(ExchangeStatus.ERROR);
        this.deliveryChannel.send(me);
    }

    protected void done(MessageExchange me) throws MessagingException {
        me.setStatus(ExchangeStatus.DONE);
        this.deliveryChannel.send(me);
    }

    private class MessageExchangeWorker
    implements Work {
        private MessageExchange me;

        public MessageExchangeWorker(MessageExchange me) {
            this.me = me;
        }

        public void release() {
        }

        public void run() {
            try {
                try {
                    NormalizedMessage nm = this.me.getMessage("IN");
                    if (nm != null) {
                        UMOMessage response = JbiMessageReceiver.this.routeMessage((UMOMessage)new MuleMessage(JbiMessageReceiver.this.connector.getMessageAdapter(nm)));
                        if (response != null) {
                            NormalizedMessage nmResposne = this.me.createMessage();
                            JbiUtils.populateNormalizedMessage(response, nmResposne);
                            this.me.setMessage(nmResposne, "OUT");
                        }
                    } else {
                        JbiMessageReceiver.this.logger.debug((Object)"'IN' message on exchange was not set");
                    }
                    JbiMessageReceiver.this.done(this.me);
                }
                catch (MessagingException e) {
                    JbiMessageReceiver.this.error(this.me, (Exception)((Object)e));
                }
            }
            catch (Exception e) {
                JbiMessageReceiver.this.handleException(e);
            }
        }
    }
}

