/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.jbi.components;

import java.io.OutputStream;
import javax.jbi.JBIException;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import org.mule.MuleManager;
import org.mule.config.converters.QNameConverter;
import org.mule.config.i18n.Message;
import org.mule.impl.MuleDescriptor;
import org.mule.impl.MuleMessage;
import org.mule.providers.AbstractMessageReceiver;
import org.mule.providers.InternalMessageListener;
import org.mule.providers.jbi.JbiMessageAdapter;
import org.mule.providers.jbi.JbiUtils;
import org.mule.providers.jbi.components.AbstractEndpointComponent;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMODescriptor;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.UMOTransaction;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.lifecycle.RecoverableException;
import org.mule.umo.provider.UMOMessageAdapter;
import org.mule.umo.provider.UMOMessageReceiver;

public class MuleReceiver
extends AbstractEndpointComponent
implements InternalMessageListener {
    private AbstractMessageReceiver receiver;
    protected QName targetService;
    protected String targetServiceName;
    static /* synthetic */ Class class$javax$xml$namespace$QName;
    static /* synthetic */ Class class$org$mule$providers$AbstractMessageReceiver;

    public QName getTargetService() {
        return this.targetService;
    }

    public void setTargetService(QName targetService) {
        this.targetService = targetService;
    }

    public AbstractMessageReceiver getReceiver() {
        return this.receiver;
    }

    public void setReceiver(AbstractMessageReceiver receiver) {
        this.receiver = receiver;
    }

    public String getTargetServiceName() {
        return this.targetServiceName;
    }

    public void setTargetServiceName(String targetServiceName) {
        this.targetServiceName = targetServiceName;
    }

    protected void doInit() throws JBIException {
        super.doInit();
        try {
            UMOMessageReceiver receiver;
            if (this.targetService == null && this.targetServiceName != null) {
                this.targetService = (QName)new QNameConverter().convert(class$javax$xml$namespace$QName == null ? (class$javax$xml$namespace$QName = MuleReceiver.class$("javax.xml.namespace.QName")) : class$javax$xml$namespace$QName, (Object)this.targetServiceName);
            }
            if ((receiver = this.muleEndpoint.getConnector().registerListener((UMOComponent)new NullUMOComponent(this.getName()), this.muleEndpoint)) == null) {
                throw new NullPointerException(new Message("jbi", 1, (Object)this.getName()).toString());
            }
            if (!(receiver instanceof AbstractMessageReceiver)) {
                throw new IllegalArgumentException(new Message("jbi", 2, (Object)this.getName(), (Object)(class$org$mule$providers$AbstractMessageReceiver == null ? (class$org$mule$providers$AbstractMessageReceiver = MuleReceiver.class$("org.mule.providers.AbstractMessageReceiver")) : class$org$mule$providers$AbstractMessageReceiver).getName()).toString());
            }
            this.receiver = (AbstractMessageReceiver)receiver;
            this.receiver.setListener((InternalMessageListener)this);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new JBIException((Throwable)e);
        }
    }

    public UMOMessage onMessage(UMOMessage message, UMOTransaction trans, boolean synchronous, OutputStream outputStream) throws UMOException {
        Object me = null;
        try {
            me = synchronous ? this.exchangeFactory.createInOutExchange() : this.exchangeFactory.createInOnlyExchange();
            if (this.targetService != null) {
                me.setService(this.targetService);
                ServiceEndpoint endpoint = null;
                ServiceEndpoint[] eps = this.context.getEndpointsForService(this.targetService);
                if (eps.length == 0) {
                    throw new MessagingException("There are no endpoints registered for targetService: " + this.targetService);
                }
                endpoint = eps[0];
                if (this.logger.isDebugEnabled()) {
                    StringBuffer buf = new StringBuffer();
                    buf.append("Found the following endpoints for: ").append(this.targetService).append("\n");
                    for (int i = 0; i < eps.length; ++i) {
                        ServiceEndpoint ep = eps[i];
                        buf.append(ep.getEndpointName()).append(";").append(ep.getServiceName()).append(";").append(ep.getInterfaces()).append("\n");
                    }
                    this.logger.debug((Object)buf.toString());
                }
                this.logger.debug((Object)("Using Jbi Endpoint for targetService: " + this.targetService + " is: " + endpoint));
                if (endpoint != null) {
                    me.setEndpoint(endpoint);
                }
            } else {
                this.logger.debug((Object)"Jbi target service is not set Container will need to resolve target");
            }
            NormalizedMessage nmessage = me.createMessage();
            JbiUtils.populateNormalizedMessage(message, nmessage);
            me.setMessage(nmessage, "in");
            if (synchronous) {
                this.deliveryChannel.sendSync((MessageExchange)me, (long)MuleManager.getConfiguration().getSynchronousEventTimeout());
                NormalizedMessage result = null;
                result = me.getMessage("out");
                this.done((MessageExchange)me);
                if (result != null) {
                    return new MuleMessage((UMOMessageAdapter)new JbiMessageAdapter(result));
                }
                return null;
            }
            this.deliveryChannel.send((MessageExchange)me);
            return null;
        }
        catch (MessagingException e) {
            try {
                this.error((MessageExchange)me, (Exception)((Object)e));
                return null;
            }
            catch (MessagingException e1) {
                this.handleException(e);
                return null;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class NullUMOComponent
    implements UMOComponent {
        private UMODescriptor descriptor;

        public NullUMOComponent(String name) {
            this.descriptor = new MuleDescriptor(name);
        }

        public UMODescriptor getDescriptor() {
            return this.descriptor;
        }

        public void dispatchEvent(UMOEvent event) throws UMOException {
            throw new UnsupportedOperationException("NullComponent:dispatchEvent");
        }

        public UMOMessage sendEvent(UMOEvent event) throws UMOException {
            throw new UnsupportedOperationException("NullComponent:sendEvent");
        }

        public void pause() throws UMOException {
        }

        public void resume() throws UMOException {
        }

        public void start() throws UMOException {
        }

        public void stop() throws UMOException {
        }

        public void dispose() {
        }

        public void initialise() throws InitialisationException, RecoverableException {
        }
    }
}

