/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.jbi.components;

import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.transform.Source;
import org.mule.providers.jbi.components.AbstractJbiComponent;
import org.mule.umo.transformer.TransformerException;
import org.mule.umo.transformer.UMOTransformer;

public class TransformerComponent
extends AbstractJbiComponent {
    protected UMOTransformer transformer = null;

    public void onMessage(MessageExchange messageExchange, NormalizedMessage message) throws MessagingException {
        if (messageExchange.getRole() == MessageExchange.Role.PROVIDER) {
            return;
        }
        NormalizedMessage in = messageExchange.getMessage("in");
        try {
            NormalizedMessage out = messageExchange.createMessage();
            this.transform(messageExchange, in, out);
            if (messageExchange instanceof InOut) {
                messageExchange.setMessage(out, "out");
            } else {
                InOnly outExchange = this.exchangeFactory.createInOnlyExchange();
                outExchange.setInMessage(out);
                this.deliveryChannel.sendSync((MessageExchange)outExchange);
            }
            this.done(messageExchange);
        }
        catch (Exception e) {
            this.error(messageExchange, e);
        }
    }

    protected void transform(MessageExchange exchange, NormalizedMessage in, NormalizedMessage out) throws TransformerException, MessagingException {
        Object result = this.transformer.transform((Object)in.getContent());
        if (!(result instanceof Source)) {
            throw new UnsupportedOperationException("Support for Source transformation is not yet implemented");
        }
        out.setContent((Source)result);
    }
}

